/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.scripts.engine.injectors;

import java.util.HashMap;
import java.util.Stack;
import org.graalvm.polyglot.Value;
import org.phoenicis.scripts.engine.implementation.PhoenicisScriptEngine;
import org.phoenicis.scripts.engine.injectors.EngineInjector;
import org.phoenicis.scripts.exceptions.CircularIncludeException;
import org.phoenicis.scripts.exceptions.IncludeException;
import org.phoenicis.scripts.exceptions.ScriptException;
import org.phoenicis.scripts.exceptions.ScriptNotFoundException;
import org.phoenicis.scripts.interpreter.ScriptFetcher;

public class IncludeInjector
implements EngineInjector {
    private final ScriptFetcher scriptFetcher;

    public IncludeInjector(ScriptFetcher scriptFetcher) {
        this.scriptFetcher = scriptFetcher;
    }

    @Override
    public void injectInto(PhoenicisScriptEngine phoenicisScriptEngine) {
        Stack includeStack = new Stack();
        HashMap includedScripts = new HashMap();
        phoenicisScriptEngine.put("include", argument -> {
            if (includeStack.contains(argument)) {
                throw new CircularIncludeException((String)argument, includeStack);
            }
            includeStack.push(argument);
            if (!includedScripts.containsKey(argument)) {
                String script = this.scriptFetcher.getScript((String)argument);
                if (script == null) {
                    throw new ScriptNotFoundException((String)argument);
                }
                try {
                    String extendedString = String.format("(module) => { %s }", script);
                    Value includeFunction = (Value)phoenicisScriptEngine.evalAndReturn(extendedString, this::throwException);
                    Value module = (Value)phoenicisScriptEngine.evalAndReturn("({})", this::throwException);
                    includeFunction.execute(new Object[]{module});
                    if (module.hasMember("default")) {
                        includedScripts.put(argument, module.getMember("default"));
                    } else {
                        includedScripts.put(argument, module);
                    }
                }
                catch (ScriptException se) {
                    throw new IncludeException((String)argument, se);
                }
            }
            includeStack.pop();
            return includedScripts.get(argument);
        }, this::throwException);
    }
}

