/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.scripts.engine.injectors;

import java.lang.annotation.Annotation;
import org.phoenicis.configuration.security.Safe;
import org.phoenicis.scripts.engine.implementation.PhoenicisScriptEngine;
import org.phoenicis.scripts.engine.injectors.EngineInjector;
import org.springframework.context.ApplicationContext;

public class BeanInjector
implements EngineInjector {
    private final ApplicationContext applicationContext;

    public BeanInjector(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public void injectInto(PhoenicisScriptEngine phoenicisScriptEngine) {
        phoenicisScriptEngine.put("Bean", this::fetchBean, this::throwException);
    }

    private Object fetchBean(String beanName) {
        Object bean = this.applicationContext.getBean(beanName);
        Class<?> beanClass = bean.getClass();
        for (Annotation annotation : beanClass.getAnnotations()) {
            if (annotation.annotationType() != Safe.class) continue;
            return bean;
        }
        throw new IllegalAccessError(String.format("You are not allowed to instanciate %s (of class %s) from a script.", beanName, beanClass.getName()));
    }
}

