/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.scripts;

import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import org.phoenicis.multithreading.MultithreadingConfiguration;
import org.phoenicis.repository.RepositoryConfiguration;
import org.phoenicis.scripts.engine.PhoenicisScriptEngineFactory;
import org.phoenicis.scripts.engine.ScriptEngineType;
import org.phoenicis.scripts.engine.injectors.BeanInjector;
import org.phoenicis.scripts.engine.injectors.IncludeInjector;
import org.phoenicis.scripts.engine.injectors.LocalisationInjector;
import org.phoenicis.scripts.engine.injectors.ScriptUtilitiesInjector;
import org.phoenicis.scripts.engine.injectors.SetupWizardInjector;
import org.phoenicis.scripts.interpreter.BackgroundScriptInterpreter;
import org.phoenicis.scripts.interpreter.PhoenicisScriptInterpreter;
import org.phoenicis.scripts.interpreter.ScriptFetcher;
import org.phoenicis.scripts.interpreter.ScriptInterpreter;
import org.phoenicis.scripts.wizard.WizardConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={WizardConfiguration.class})
public class ScriptsConfiguration {
    @Autowired
    private WizardConfiguration wizardConfiguration;
    @Autowired
    private RepositoryConfiguration repositoryConfiguration;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private MultithreadingConfiguration multithreadingConfiguration;

    @Bean
    public PhoenicisScriptEngineFactory graalScriptEngineFactory() {
        return new PhoenicisScriptEngineFactory(ScriptEngineType.GRAAL, Arrays.asList(new ScriptUtilitiesInjector(), new BeanInjector(this.applicationContext), new SetupWizardInjector(this.wizardConfiguration.setupWizardFactory()), new IncludeInjector(this.scriptFetcher()), new LocalisationInjector()));
    }

    @Bean
    public ScriptFetcher scriptFetcher() {
        return new ScriptFetcher(this.repositoryConfiguration.repositoryManager());
    }

    @Bean
    public ScriptInterpreter scriptInterpreter() {
        return new BackgroundScriptInterpreter(this.graalScriptInterpreter(), (ExecutorService)this.multithreadingConfiguration.scriptExecutorService());
    }

    @Bean
    ScriptInterpreter graalScriptInterpreter() {
        return new PhoenicisScriptInterpreter(this.graalScriptEngineFactory());
    }
}

