/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.win32.registry;

import org.phoenicis.win32.registry.AbstractRegistryNode;
import org.phoenicis.win32.registry.AbstractValueType;
import org.phoenicis.win32.registry.BinaryValueType;
import org.phoenicis.win32.registry.DwordValueType;
import org.phoenicis.win32.registry.ExpandableValueType;
import org.phoenicis.win32.registry.MultiStringValueType;
import org.phoenicis.win32.registry.StringValueType;

public class RegistryValue<T extends AbstractValueType>
extends AbstractRegistryNode {
    private final T content;

    public RegistryValue(String name, T content) {
        super(name);
        this.content = content;
    }

    public static RegistryValue<AbstractValueType> fromString(String name, String inputString) {
        RegistryValue<AbstractValueType> parsedValue;
        if (inputString.startsWith("\"") && inputString.endsWith("\"")) {
            String valueContentString = inputString.substring(1, inputString.length() - 1);
            valueContentString = valueContentString.replaceAll("\\\\\\\"", "\"");
            if ((valueContentString = valueContentString.replaceAll("\\\\\\\\", "\\\\")).endsWith("\\0")) {
                valueContentString = valueContentString.substring(0, valueContentString.length() - 2);
            }
            parsedValue = new RegistryValue<AbstractValueType>(name, new StringValueType(valueContentString));
        } else if (inputString.contains(":")) {
            int colPosition = inputString.indexOf(58);
            String valueTypeString = inputString.substring(0, colPosition);
            String valueContentString = inputString.substring(colPosition + 1, inputString.length());
            if (valueContentString.endsWith("\\0")) {
                valueContentString = valueContentString.substring(0, valueContentString.length() - 2);
            }
            switch (valueTypeString) {
                case "str(7)": {
                    parsedValue = new RegistryValue<MultiStringValueType>(name, new MultiStringValueType(valueContentString));
                    break;
                }
                case "str(2)": {
                    parsedValue = new RegistryValue<ExpandableValueType>(name, new ExpandableValueType(valueContentString));
                    break;
                }
                case "dword": {
                    long dwordValue = Long.valueOf(valueContentString, 16);
                    parsedValue = new RegistryValue<DwordValueType>(name, new DwordValueType(dwordValue));
                    break;
                }
                case "hex": 
                case "hex(6)": 
                case "hex(2)": 
                case "hex(7)": {
                    String[] binariesString = valueContentString.split(",");
                    byte[] binaries = new byte[binariesString.length];
                    for (int i = 0; i < binariesString.length; ++i) {
                        binaries[i] = (byte)(Integer.valueOf(binariesString[i], 16) - 128);
                    }
                    parsedValue = new RegistryValue<BinaryValueType>(name, new BinaryValueType(binaries));
                    break;
                }
                default: {
                    parsedValue = new RegistryValue<StringValueType>(name, new StringValueType(""));
                    break;
                }
            }
        } else {
            throw new IllegalArgumentException(String.format("Unable to format registry line: %s", inputString));
        }
        return parsedValue;
    }

    public String getText() {
        return ((AbstractValueType)this.content).getText();
    }

    @Override
    public String toString() {
        return String.format("- (%s) %s -> %s", this.content.getClass().getSimpleName(), this.getName(), ((AbstractValueType)this.content).getText());
    }

    @Override
    public String toRegString() {
        return String.format("\"%s\"=%s", this.getName(), ((AbstractValueType)this.content).toRegString());
    }
}

