/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.win32.registry;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import org.apache.commons.lang.StringUtils;
import org.phoenicis.configuration.security.Safe;
import org.phoenicis.win32.registry.AbstractValueType;
import org.phoenicis.win32.registry.RegistryKey;
import org.phoenicis.win32.registry.RegistryValue;

@Safe
public class RegistryParser {
    private static final char QUOTE = '\"';
    private static final String PARSE_ERROR_MESSAGE = "Invalid registry file. Error found line %s";

    /*
     * Unable to fully structure code
     */
    public RegistryKey parseFile(File registryFile, String rootName) {
        bufferReader = new BufferedReader(new FileReader(registryFile));
        try {
            root = new RegistryKey(rootName);
            lastNode = null;
            lineNumber = 1;
            currentLine = bufferReader.readLine();
            while (currentLine != null) {
                block13: {
                    block14: {
                        block12: {
                            while (currentLine.trim().endsWith("\\")) {
                                currentLine = StringUtils.substring((String)currentLine.trim(), (int)0, (int)-1) + bufferReader.readLine().trim();
                            }
                            if (!currentLine.startsWith(";") && !currentLine.startsWith("#") && !StringUtils.isBlank((String)currentLine) && !currentLine.startsWith("@")) break block12;
                            ++lineNumber;
                            break block13;
                        }
                        if (!currentLine.startsWith("[")) break block14;
                        lastNode = this.parseDirectoryLine(root, (String)currentLine);
                        ** GOTO lbl26
                    }
                    if (lineNumber == 1) {
                        ++lineNumber;
                    } else {
                        if (lastNode == null) {
                            throw new ParseException(String.format("Invalid registry file. Error found line %s", new Object[]{lineNumber}), 0);
                        }
                        this.parseValueLine(lastNode, (String)currentLine, lineNumber);
lbl26:
                        // 2 sources

                        ++lineNumber;
                    }
                }
                currentLine = bufferReader.readLine();
            }
            var7_10 = root;
        }
        catch (Throwable var4_6) {
            try {
                try {
                    bufferReader.close();
                }
                catch (Throwable var5_8) {
                    var4_6.addSuppressed(var5_8);
                }
                throw var4_6;
            }
            catch (IOException | ParseException e) {
                throw new IllegalArgumentException("Error while parsing the registry", e);
            }
        }
        bufferReader.close();
        return var7_10;
    }

    private void parseValueLine(RegistryKey lastNode, String currentLine, int lineNumber) throws ParseException {
        if (!currentLine.startsWith("\"")) {
            throw new ParseException(String.format(PARSE_ERROR_MESSAGE, lineNumber), 0);
        }
        StringBuilder nameBuilder = new StringBuilder();
        StringBuilder valueBuilder = new StringBuilder();
        ParseState parseState = ParseState.INITIAL;
        Boolean ignoreNextQuote = false;
        for (int i = 0; i < currentLine.length(); ++i) {
            char currentChar = currentLine.charAt(i);
            if (parseState == ParseState.INITIAL) {
                if (currentChar != '\"') continue;
                parseState = ParseState.READING_NAME;
                continue;
            }
            if (parseState == ParseState.READING_NAME) {
                if (currentChar == '\"' && !ignoreNextQuote.booleanValue()) {
                    parseState = ParseState.SEPARATOR;
                    continue;
                }
                if (currentChar == '\\' && !ignoreNextQuote.booleanValue()) {
                    ignoreNextQuote = true;
                    continue;
                }
                nameBuilder.append(currentChar);
                ignoreNextQuote = false;
                continue;
            }
            if (parseState == ParseState.SEPARATOR) {
                if (currentChar != '=') {
                    throw new ParseException(String.format(PARSE_ERROR_MESSAGE, lineNumber), 0);
                }
                parseState = ParseState.READING_VALUE;
                continue;
            }
            valueBuilder.append(currentChar);
        }
        String name = nameBuilder.toString();
        try {
            RegistryValue<AbstractValueType> value = RegistryValue.fromString(name, valueBuilder.toString());
            lastNode.addChild(value);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(String.format("Error on line %s (%s-: %s", lineNumber, currentLine, e), 0);
        }
    }

    private RegistryKey parseDirectoryLine(RegistryKey root, String currentLine) {
        String extractedLine = this.extractDirectoryLine(currentLine);
        String[] splitLine = extractedLine.split("\\\\\\\\");
        RegistryKey currentKey = root;
        for (String registryKeyName : splitLine) {
            RegistryKey childrenSearched = (RegistryKey)currentKey.getChild(registryKeyName);
            if (childrenSearched != null) {
                currentKey = childrenSearched;
                continue;
            }
            RegistryKey newChild = new RegistryKey(registryKeyName);
            currentKey.addChild(newChild);
            currentKey = newChild;
        }
        return currentKey;
    }

    private String extractDirectoryLine(String currentLine) {
        return currentLine.substring(1, currentLine.indexOf(93));
    }

    static enum ParseState {
        INITIAL,
        READING_NAME,
        SEPARATOR,
        READING_VALUE;

    }
}

