/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.win32.registry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.phoenicis.win32.registry.AbstractRegistryNode;

public class RegistryKey
extends AbstractRegistryNode {
    private final List<AbstractRegistryNode> children = new ArrayList<AbstractRegistryNode>();

    public RegistryKey(String name) {
        super(name);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("+ ").append(this.name).append("\n");
        for (AbstractRegistryNode child : this.children) {
            for (String line : child.toString().split("\n")) {
                stringBuilder.append("| ").append(line).append("\n");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public String toRegString() {
        ArrayList<String> registryPath = new ArrayList<String>();
        RegistryKey registryNode = this;
        while (registryNode != null) {
            registryPath.add(0, registryNode.getName());
            registryNode = registryNode.parent;
        }
        return "\n[" + String.join((CharSequence)"\\", registryPath) + "]";
    }

    public AbstractRegistryNode addChild(AbstractRegistryNode newChild) {
        this.children.add(newChild);
        newChild.setParent(this);
        return newChild;
    }

    public AbstractRegistryNode addDeepChildren(AbstractRegistryNode ... newChildren) {
        return this.addDeepChildren(Arrays.asList(newChildren));
    }

    private AbstractRegistryNode addDeepChildren(List<AbstractRegistryNode> newChildren) {
        this.addChild(newChildren.get(0));
        if (newChildren.size() > 1 && newChildren.get(0) instanceof RegistryKey) {
            ArrayList<AbstractRegistryNode> subChildren = new ArrayList<AbstractRegistryNode>(newChildren);
            subChildren.remove(0);
            return ((RegistryKey)newChildren.get(0)).addDeepChildren(subChildren);
        }
        return newChildren.get(0);
    }

    public RegistryKey addDeepChildren(String ... newChildren) {
        return (RegistryKey)this.addDeepChildren(Arrays.stream(newChildren).map(RegistryKey::new).collect(Collectors.toList()));
    }

    public List<AbstractRegistryNode> getChildren() {
        return this.children;
    }

    public AbstractRegistryNode getChild(int i) {
        return this.children.get(i);
    }

    public AbstractRegistryNode getChild(String childName) {
        for (AbstractRegistryNode child : this.children) {
            if (!childName.equals(child.getName())) continue;
            return child;
        }
        return null;
    }

    public AbstractRegistryNode getChild(List<String> childrenNames) {
        RegistryKey currentLevel = this;
        for (String child : childrenNames) {
            AbstractRegistryNode nextLevel = currentLevel.getChild(child);
            if (nextLevel instanceof RegistryKey) {
                currentLevel = (RegistryKey)nextLevel;
                continue;
            }
            return nextLevel;
        }
        return currentLevel;
    }

    public AbstractRegistryNode getChild(String ... childrenNames) {
        return this.getChild(Arrays.asList(childrenNames));
    }

    public void addChildren(AbstractRegistryNode ... nodes) {
        for (AbstractRegistryNode node : nodes) {
            this.addChild(node);
        }
    }
}

