/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.win32.pe;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.phoenicis.win32.ULong;

public class SectionHeader {
    public static final int SECTION_HEADER_SIZE = 40;
    final byte[] name = new byte[8];
    final ULong physicalAddressOrVirtualSize;
    final ULong virtualAddress;
    final ULong sizeOfRawData;
    final ULong pointerToRawData;
    final ULong pointerToRelocations;
    final ULong pointerToLinenumbers;
    final Short numberOfRelocations;
    final Short numberOfLineNumbers;
    final ULong characteristics;

    public SectionHeader(byte[] bytes) {
        if (bytes.length != 40) {
            throw new IllegalStateException("Section Header should be 40 bytes");
        }
        System.arraycopy(bytes, 0, this.name, 0, 8);
        this.physicalAddressOrVirtualSize = new ULong(bytes, 8);
        this.virtualAddress = new ULong(bytes, 12);
        this.sizeOfRawData = new ULong(bytes, 16);
        this.pointerToRawData = new ULong(bytes, 20);
        this.pointerToRelocations = new ULong(bytes, 24);
        this.pointerToLinenumbers = new ULong(bytes, 28);
        this.numberOfRelocations = this.readShort(bytes, 32);
        this.numberOfLineNumbers = this.readShort(bytes, 34);
        this.characteristics = new ULong(bytes, 36);
    }

    private Short readShort(byte[] bytes, int offset) {
        return ByteBuffer.wrap(bytes, offset, 2).order(ByteOrder.LITTLE_ENDIAN).getShort();
    }
}

