/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.win32.pe;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.CountingInputStream;
import org.phoenicis.win32.pe.ImageDOSHeader;
import org.phoenicis.win32.pe.ImageNTHeaders;
import org.phoenicis.win32.pe.PEFile;
import org.phoenicis.win32.pe.SectionHeader;
import org.phoenicis.win32.pe.rsrc.RsrcSection;

public final class PEReader {
    public PEFile parseExecutable(InputStream inputStream) throws IOException {
        try (CountingInputStream executableInputStream = new CountingInputStream(inputStream);){
            ImageDOSHeader imageDOSHeader = this.readDosHeader((InputStream)executableInputStream);
            byte[] realModeStubProgram = this.readRealModeStubProgram((InputStream)executableInputStream, imageDOSHeader);
            ImageNTHeaders imageNTHeaders = this.readImageNTHeaders((InputStream)executableInputStream);
            SectionHeader[] sectionHeaders = this.readSectionHeaders(executableInputStream, imageNTHeaders);
            RsrcSection resourceSection = this.readResourceSection(executableInputStream, sectionHeaders);
            PEFile pEFile = new PEFile(imageDOSHeader, realModeStubProgram, imageNTHeaders, sectionHeaders, resourceSection);
            return pEFile;
        }
    }

    private RsrcSection readResourceSection(CountingInputStream executableInputStream, SectionHeader[] sectionHeaders) throws IOException {
        SectionHeader rsrcSectionHeader = null;
        for (SectionHeader sectionHeader : sectionHeaders) {
            if (!".rsrc\u0000\u0000\u0000".equals(new String(sectionHeader.name))) continue;
            rsrcSectionHeader = sectionHeader;
        }
        if (rsrcSectionHeader == null) {
            return null;
        }
        long numberToSkip = rsrcSectionHeader.pointerToRawData.getUnsignedValue() - (long)executableInputStream.getCount();
        executableInputStream.skip(numberToSkip);
        byte[] rsrcSection = new byte[(int)rsrcSectionHeader.sizeOfRawData.getUnsignedValue()];
        executableInputStream.read(rsrcSection);
        return new RsrcSection(rsrcSection);
    }

    private SectionHeader[] readSectionHeaders(CountingInputStream executableInputStream, ImageNTHeaders imageNTHeaders) throws IOException {
        int numberOfSectionHeaders = imageNTHeaders.fileHeader.numberOfSections.getUnsignedValue();
        SectionHeader[] sectionHeaders = new SectionHeader[numberOfSectionHeaders];
        for (int i = 0; i < numberOfSectionHeaders; ++i) {
            byte[] sectionHeaderBytes = new byte[40];
            executableInputStream.read(sectionHeaderBytes);
            sectionHeaders[i] = new SectionHeader(sectionHeaderBytes);
        }
        return sectionHeaders;
    }

    private ImageNTHeaders readImageNTHeaders(InputStream executableInputStream) throws IOException {
        byte[] byteImageNTHeader = new byte[24];
        executableInputStream.read(byteImageNTHeader);
        ImageNTHeaders imageNTHeaders = new ImageNTHeaders(byteImageNTHeader);
        int optionalHeaderSize = imageNTHeaders.fileHeader.sizeOfOptionalHeader.getUnsignedValue();
        byte[] optionalHeader = new byte[optionalHeaderSize];
        executableInputStream.read(optionalHeader);
        imageNTHeaders.readOptionalHeader(optionalHeader);
        return imageNTHeaders;
    }

    private byte[] readRealModeStubProgram(InputStream executableInputStream, ImageDOSHeader imageDOSHeader) throws IOException {
        byte[] realModeStubProgram = new byte[imageDOSHeader.eLfanew - 64];
        executableInputStream.read(realModeStubProgram);
        return realModeStubProgram;
    }

    private ImageDOSHeader readDosHeader(InputStream executableInputStream) throws IOException {
        byte[] byteImageDosHeader = new byte[64];
        executableInputStream.read(byteImageDosHeader);
        return new ImageDOSHeader(byteImageDosHeader);
    }
}

