/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.win32.pe;

import org.phoenicis.win32.pe.ImageDOSHeader;
import org.phoenicis.win32.pe.ImageNTHeaders;
import org.phoenicis.win32.pe.SectionHeader;
import org.phoenicis.win32.pe.rsrc.RsrcSection;

public class PEFile {
    public final ImageDOSHeader imageDOSHeader;
    public final byte[] realModeStubProgram;
    public final ImageNTHeaders imageNTHeaders;
    public final SectionHeader[] sectionHeaders;
    public final RsrcSection resourceSection;

    public PEFile(ImageDOSHeader imageDOSHeader, byte[] realModeStubProgram, ImageNTHeaders imageNTHeaders, SectionHeader[] sectionHeaders, RsrcSection resourceSection) {
        this.imageDOSHeader = imageDOSHeader;
        this.realModeStubProgram = realModeStubProgram;
        this.imageNTHeaders = imageNTHeaders;
        this.sectionHeaders = sectionHeaders;
        this.resourceSection = resourceSection;
    }

    public Architecture getArchitecture() {
        switch (this.imageNTHeaders.fileHeader.machine.getUnsignedValue()) {
            case 332: {
                return Architecture.I386;
            }
            case 34404: {
                return Architecture.AMD64;
            }
            case 512: {
                return Architecture.IA64;
            }
        }
        throw new IllegalArgumentException("The file is not a valid .exe file");
    }

    public static enum Architecture {
        AMD64,
        I386,
        IA64;

    }
}

