/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.win32.pe;

import org.phoenicis.win32.DWord;
import org.phoenicis.win32.Word;
import org.phoenicis.win32.pe.ImageDataDirectory;

public class ImageOptionalHeader {
    public static final int IMAGE_OPTIONAL_HEADER_BASE_SIZE = 96;
    final Word magic;
    final Byte majorLinkerVersion;
    final Byte minorLinkerVersion;
    final DWord sizeOfCode;
    final DWord sizeOfInitializedData;
    final DWord sizeOfUninitializedData;
    final DWord addressOfEntryPoint;
    final DWord baseOfCode;
    final DWord baseOfData;
    final DWord imageBase;
    final DWord sectionAlignment;
    final DWord fileAlignment;
    final Word majorOperatingSystemVersion;
    final Word minorOperatingSystemVersion;
    final Word majorImageVersion;
    final Word minorImageVersion;
    final Word majorSubsystemVersion;
    final Word minorSubsystemVersion;
    final DWord win32VersionValue;
    final DWord sizeOfImage;
    final DWord sizeOfHeaders;
    final DWord checkSum;
    final Word subsystem;
    final Word dllCharacteristics;
    final DWord sizeOfStackReserve;
    final DWord sizeOfStackCommit;
    final DWord sizeOfHeapReserve;
    final DWord sizeOfHeapCommit;
    final DWord loaderFlags;
    final DWord numberOfRvaAndSizes;
    final ImageDataDirectory[] dataDirectory;

    public ImageOptionalHeader(byte[] bytes) {
        this.magic = new Word(bytes, 0);
        this.majorLinkerVersion = bytes[2];
        this.minorLinkerVersion = bytes[3];
        this.sizeOfCode = new DWord(bytes, 4);
        this.sizeOfInitializedData = new DWord(bytes, 8);
        this.sizeOfUninitializedData = new DWord(bytes, 12);
        this.addressOfEntryPoint = new DWord(bytes, 16);
        this.baseOfCode = new DWord(bytes, 20);
        this.baseOfData = new DWord(bytes, 24);
        this.imageBase = new DWord(bytes, 28);
        this.sectionAlignment = new DWord(32);
        this.fileAlignment = new DWord(36);
        this.majorOperatingSystemVersion = new Word(bytes, 40);
        this.minorOperatingSystemVersion = new Word(bytes, 42);
        this.majorImageVersion = new Word(bytes, 44);
        this.minorImageVersion = new Word(bytes, 46);
        this.majorSubsystemVersion = new Word(bytes, 48);
        this.minorSubsystemVersion = new Word(bytes, 50);
        this.win32VersionValue = new DWord(bytes, 52);
        this.sizeOfImage = new DWord(bytes, 56);
        this.sizeOfHeaders = new DWord(bytes, 60);
        this.checkSum = new DWord(bytes, 64);
        this.subsystem = new Word(bytes, 68);
        this.dllCharacteristics = new Word(bytes, 70);
        this.sizeOfStackReserve = new DWord(bytes, 72);
        this.sizeOfStackCommit = new DWord(bytes, 76);
        this.sizeOfHeapReserve = new DWord(bytes, 80);
        this.sizeOfHeapCommit = new DWord(bytes, 84);
        this.loaderFlags = new DWord(bytes, 88);
        this.numberOfRvaAndSizes = new DWord(bytes, 92);
        int numberOfDirectoryEntries = (bytes.length - 96) / 8;
        this.dataDirectory = new ImageDataDirectory[numberOfDirectoryEntries];
        for (int i = 0; i < numberOfDirectoryEntries; ++i) {
            this.dataDirectory[i] = new ImageDataDirectory(bytes, 96 + i * 8);
        }
    }
}

