/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.win32.pe;

import org.phoenicis.win32.DWord;
import org.phoenicis.win32.Word;

public class ImageFileHeader {
    public static final int IMAGE_FILE_HEADER_SIZE = 20;
    final Word machine;
    final Word numberOfSections;
    final DWord timeDateStamp;
    final DWord pointerToSymbolTable;
    final DWord numberOfSymbols;
    final Word sizeOfOptionalHeader;
    final Word characteristics;

    public ImageFileHeader(byte[] bytes, int offset) {
        if (bytes.length != 20 + offset) {
            throw new IllegalStateException("An ImageFileHeader should be 20 bytes long. Got " + bytes.length);
        }
        this.machine = new Word(bytes, offset);
        this.numberOfSections = new Word(bytes, 2 + offset);
        this.timeDateStamp = new DWord(bytes, 4 + offset);
        this.pointerToSymbolTable = new DWord(bytes, 8 + offset);
        this.numberOfSymbols = new DWord(bytes, 12 + offset);
        this.sizeOfOptionalHeader = new Word(bytes, 16 + offset);
        this.characteristics = new Word(bytes, 18 + offset);
    }
}

