/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.win32.pe;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.phoenicis.win32.Word;

public class ImageDOSHeader {
    public static final int IMAGE_DOS_HEADER_SIZE = 64;
    final Word eMagic;
    final Word eCblp;
    final Word eCp;
    final Word eCrlc;
    final Word eCparhdr;
    final Word eMinalloc;
    final Word eMaxalloc;
    final Word eSs;
    final Word eSp;
    final Word eCsum;
    final Word eIp;
    final Word eCs;
    final Word eLfarlc;
    final Word eOvno;
    final Word[] eRes = new Word[4];
    final Word eOemid;
    final Word eOeminfo;
    final Word[] eRes2 = new Word[10];
    final Integer eLfanew;

    ImageDOSHeader(byte[] bytes) {
        int i;
        if (bytes.length != 64) {
            throw new IllegalStateException("An ImageDOSHeader should be 64 bytes long");
        }
        this.eMagic = new Word(bytes, 0);
        this.eCblp = new Word(bytes, 2);
        this.eCp = new Word(bytes, 4);
        this.eCrlc = new Word(bytes, 6);
        this.eCparhdr = new Word(bytes, 8);
        this.eMinalloc = new Word(bytes, 10);
        this.eMaxalloc = new Word(bytes, 12);
        this.eSs = new Word(bytes, 14);
        this.eSp = new Word(bytes, 16);
        this.eCsum = new Word(bytes, 18);
        this.eIp = new Word(bytes, 20);
        this.eCs = new Word(bytes, 22);
        this.eLfarlc = new Word(bytes, 24);
        for (i = 0; i < 4; ++i) {
            this.eRes[i] = new Word(bytes, 26 + 2 * i);
        }
        this.eOemid = new Word(bytes, 34);
        this.eOeminfo = new Word(bytes, 36);
        for (i = 0; i < 10; ++i) {
            this.eRes2[i] = new Word(bytes, 38 + 2 * i);
        }
        this.eOvno = new Word(bytes, 58);
        this.eLfanew = ByteBuffer.wrap(bytes, 60, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }
}

