/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.lnk;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.phoenicis.lnk.BytesUtilities;
import org.phoenicis.lnk.LnkFile;
import org.phoenicis.lnk.LnkFileAttributeFlagsParser;
import org.phoenicis.lnk.LnkLinkFlagsParser;
import org.phoenicis.lnk.LnkStringData;

public class LnkParser {
    private static final int LNK_HEADER_SIZE = 76;
    private static final int FILE_LOCATION_INFO_FLAG_OFFSET_OFFSET = 8;
    private static final int BASENAME_OFFSET_OFFSET = 16;
    private static final int NETWORK_VOLUME_TABLE_OFFSET_OFFSET = 20;
    private static final int FINALNAME_OFFSET_OFFSET = 24;
    private static final int SHARE_NAME_OFFSET_OFFSET = 8;

    public LnkFile parse(File file) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            LnkFile lnkFile = this.parse(inputStream);
            return lnkFile;
        }
    }

    public LnkFile parse(byte[] rawLnkShortcutByteArray) {
        LnkFileAttributeFlagsParser fileAttributes = this.fetchFilesAttributes(rawLnkShortcutByteArray);
        LnkLinkFlagsParser lnkDataFlag = this.fetchLnkData(rawLnkShortcutByteArray);
        boolean isDirectory = fileAttributes.hasDirMask();
        boolean hasArguments = lnkDataFlag.hasArguments();
        int fileStart = this.fetchFileStart(rawLnkShortcutByteArray, lnkDataFlag);
        byte[] rawLnkContentWithoutHeader = Arrays.copyOfRange(rawLnkShortcutByteArray, fileStart, rawLnkShortcutByteArray.length - 1);
        boolean isLocal = this.isLnkLocal(rawLnkContentWithoutHeader);
        String fileName = this.parseLnkContent(rawLnkContentWithoutHeader, isLocal);
        LnkStringData lnkStringData = this.fetchStringData(rawLnkContentWithoutHeader, lnkDataFlag);
        return new LnkFile(isDirectory, isLocal, fileName, hasArguments, lnkStringData);
    }

    private LnkStringData fetchStringData(byte[] rawLnkContentWithoutHeader, LnkLinkFlagsParser lnkDataFlags) {
        Optional<String> arguments;
        Optional<String> workingDir;
        Optional<String> relativePath;
        Optional<String> name;
        int numberOfStrings = lnkDataFlags.fetchNumberOfStringData();
        List<String> stringDatas = this.fetchStringData(rawLnkContentWithoutHeader, numberOfStrings);
        int nameIndex = 0;
        int relativePathIndex = 1;
        int workingDirIndex = 2;
        int commandLineArgumentsIndex = 3;
        int iconLocationIndex = 4;
        if (lnkDataFlags.hasName()) {
            name = Optional.of(stringDatas.get(nameIndex));
        } else {
            name = Optional.empty();
            --relativePathIndex;
            --workingDirIndex;
            --commandLineArgumentsIndex;
            --iconLocationIndex;
        }
        if (lnkDataFlags.hasRelativePath()) {
            relativePath = Optional.of(stringDatas.get(relativePathIndex));
        } else {
            relativePath = Optional.empty();
            --workingDirIndex;
            --commandLineArgumentsIndex;
            --iconLocationIndex;
        }
        if (lnkDataFlags.hasWorkingDir()) {
            workingDir = Optional.of(stringDatas.get(workingDirIndex));
        } else {
            workingDir = Optional.empty();
            --commandLineArgumentsIndex;
            --iconLocationIndex;
        }
        if (lnkDataFlags.hasArguments()) {
            arguments = Optional.of(stringDatas.get(commandLineArgumentsIndex));
        } else {
            arguments = Optional.empty();
            --iconLocationIndex;
        }
        Optional<String> iconLocation = lnkDataFlags.hasArguments() ? Optional.of(stringDatas.get(iconLocationIndex)) : Optional.empty();
        return new LnkStringData(name, relativePath, workingDir, arguments, iconLocation);
    }

    private List<String> fetchStringData(byte[] rawLnkContentWithoutHeader, int numberOfStringToRead) {
        int linkInfoSize;
        ArrayList<String> stringDatas = new ArrayList<String>();
        int index = linkInfoSize = BytesUtilities.bytes2int(rawLnkContentWithoutHeader, 0, 3);
        for (int i = 0; i < numberOfStringToRead; ++i) {
            int stringSize = BytesUtilities.bytes2int(rawLnkContentWithoutHeader, index, 2);
            String decodedString = new String(Arrays.copyOfRange(rawLnkContentWithoutHeader, index + 2, index + stringSize * 2), Charset.forName("UTF-16LE"));
            stringDatas.add(decodedString);
            index = index + stringSize * 2 + 2;
        }
        return stringDatas;
    }

    private LnkLinkFlagsParser fetchLnkData(byte[] rawLnkShortcutByteArray) {
        return new LnkLinkFlagsParser(rawLnkShortcutByteArray);
    }

    LnkFile parse(InputStream shortcutInputStream) throws IOException {
        return this.parse(IOUtils.toByteArray((InputStream)shortcutInputStream));
    }

    private boolean isLnkLocal(byte[] rawLnkContent) {
        byte fileLocationInfoFlag = rawLnkContent[8];
        return (fileLocationInfoFlag & 2) == 0;
    }

    private String parseLnkContent(byte[] rawLnkShortcutByteArrayWithoutHeader, boolean isLocal) {
        byte finalNameOffset = rawLnkShortcutByteArrayWithoutHeader[24];
        String finalName = BytesUtilities.getNullDelimitedString(rawLnkShortcutByteArrayWithoutHeader, finalNameOffset);
        if (isLocal) {
            byte basenameOffset = rawLnkShortcutByteArrayWithoutHeader[16];
            String basename = BytesUtilities.getNullDelimitedString(rawLnkShortcutByteArrayWithoutHeader, basenameOffset);
            return basename + finalName;
        }
        byte networkVolumeTableOffset = rawLnkShortcutByteArrayWithoutHeader[20];
        int shareNameOffset = rawLnkShortcutByteArrayWithoutHeader[networkVolumeTableOffset + 8] + networkVolumeTableOffset;
        String shareName = BytesUtilities.getNullDelimitedString(rawLnkShortcutByteArrayWithoutHeader, shareNameOffset);
        return shareName + "\\" + finalName;
    }

    private int fetchFileStart(byte[] rawLnkContent, LnkLinkFlagsParser dataFlags) {
        return 76 + this.fetchLinkTargetIdListLength(rawLnkContent, dataFlags);
    }

    private int fetchLinkTargetIdListLength(byte[] rawLnkContent, LnkLinkFlagsParser dataFlags) {
        int linkTargetIdListLength = 0;
        if (dataFlags.hasLinkTargetIdList()) {
            int lengthMarkerSize = 2;
            linkTargetIdListLength = BytesUtilities.bytes2int(rawLnkContent, 76, 2) + 2;
        }
        return linkTargetIdListLength;
    }

    private LnkFileAttributeFlagsParser fetchFilesAttributes(byte[] rawLnkContent) {
        return new LnkFileAttributeFlagsParser(rawLnkContent);
    }
}

