/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.lnk;

import org.phoenicis.lnk.AbstractLnkFlagsParser;

class LnkLinkFlagsParser
extends AbstractLnkFlagsParser {
    private static final int DATA_FLAG_OFFSET = 20;
    private static final byte MASK_HAS_LINK_TARGET_ID_LIST = 1;
    private static final byte MASK_HAS_NAME = 4;
    private static final byte MASK_RELATIVE_PATH = 8;
    private static final byte MASK_HAS_WORKING_DIR = 16;
    private static final byte MASK_HAS_ARGUMENTS = 32;
    private static final byte MASK_ICON_LOCATION = 64;

    LnkLinkFlagsParser(byte[] rawLnkContent) {
        super(new byte[]{rawLnkContent[20], rawLnkContent[21], rawLnkContent[22], rawLnkContent[23]});
    }

    boolean hasWorkingDir() {
        return this.testMask((byte)16);
    }

    boolean hasArguments() {
        return this.testMask((byte)32);
    }

    boolean hasLinkTargetIdList() {
        return this.testMask((byte)1);
    }

    boolean hasName() {
        return this.testMask((byte)4);
    }

    boolean hasRelativePath() {
        return this.testMask((byte)8);
    }

    boolean hasIconLocation() {
        return this.testMask((byte)64);
    }

    int fetchNumberOfStringData() {
        int number = 0;
        if (this.hasName()) {
            ++number;
        }
        if (this.hasRelativePath()) {
            ++number;
        }
        if (this.hasWorkingDir()) {
            ++number;
        }
        if (this.hasArguments()) {
            ++number;
        }
        if (this.hasIconLocation()) {
            ++number;
        }
        return number;
    }
}

