/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins.wasm;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyMemory;
import com.oracle.truffle.js.runtime.objects.JSNonProxyObject;
import com.oracle.truffle.js.runtime.objects.JSObject;

public final class JSWebAssemblyMemoryObject
extends JSNonProxyObject {
    private final Object wasmMemory;
    private DynamicObject bufferObject;

    protected JSWebAssemblyMemoryObject(Shape shape, Object wasmMemory, DynamicObject bufferObject) {
        super(shape);
        assert (JSArrayBuffer.isJSAbstractBuffer(bufferObject));
        this.wasmMemory = wasmMemory;
        this.bufferObject = bufferObject;
    }

    public Object getWASMMemory() {
        return this.wasmMemory;
    }

    public DynamicObject getBufferObject() {
        return this.bufferObject;
    }

    public void resetBufferObject() {
        DynamicObject oldBufferObject = this.bufferObject;
        JSArrayBuffer.detachArrayBuffer(oldBufferObject);
        this.bufferObject = JSWebAssemblyMemory.createBufferObject(JSObject.getJSContext(oldBufferObject), this.wasmMemory);
    }
}

