/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.module;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSReadFrameSlotNode;
import com.oracle.truffle.js.nodes.module.ReadImportBindingNode;
import com.oracle.truffle.js.runtime.objects.ExportResolution;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=ReadImportBindingNode.class)
public final class ReadImportBindingNodeGen
extends ReadImportBindingNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @Node.Child
    private CachedData cached_cache;

    private ReadImportBindingNodeGen(JavaScriptNode resolutionNode) {
        super(resolutionNode);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        ExportResolution resolutionNodeValue__;
        int state_0 = this.state_0_;
        Object resolutionNodeValue_ = this.resolutionNode.execute(frameValue);
        if ((state_0 & 3) != 0 && resolutionNodeValue_ instanceof ExportResolution) {
            CachedData s1_;
            resolutionNodeValue__ = (ExportResolution)resolutionNodeValue_;
            if ((state_0 & 1) != 0 && (s1_ = this.cached_cache) != null && s1_.frameDescriptor_ == resolutionNodeValue__.getModule().getFrameDescriptor() && s1_.bindingName_.equals(resolutionNodeValue__.getBindingName())) {
                return ReadImportBindingNode.doCached(resolutionNodeValue__, s1_.frameDescriptor_, s1_.bindingName_, s1_.readFrameSlot_);
            }
            if ((state_0 & 2) != 0) {
                return this.doUncached(resolutionNodeValue__);
            }
        }
        if ((state_0 & 4) != 0 && JSTypes.isDynamicObject(resolutionNodeValue_) && JSGuards.isJSModuleNamespace(resolutionNodeValue__ = (DynamicObject)resolutionNodeValue_)) {
            return ReadImportBindingNode.doNamespace((DynamicObject)resolutionNodeValue__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(resolutionNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.execute(frameValue);
    }

    private Object executeAndSpecialize(Object resolutionNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state_0 = this.state_0_;
        int exclude = this.exclude_;
        try {
            DynamicObject resolutionNodeValue_;
            if (resolutionNodeValue instanceof ExportResolution) {
                ExportResolution resolutionNodeValue_2 = (ExportResolution)resolutionNodeValue;
                if (exclude == 0) {
                    String bindingName__;
                    FrameDescriptor frameDescriptor__;
                    CachedData s1_ = this.cached_cache;
                    boolean Cached_duplicateFound_ = false;
                    if ((state_0 & 1) != 0 && s1_.frameDescriptor_ == resolutionNodeValue_2.getModule().getFrameDescriptor() && s1_.bindingName_.equals(resolutionNodeValue_2.getBindingName())) {
                        Cached_duplicateFound_ = true;
                    }
                    if (!Cached_duplicateFound_ && (frameDescriptor__ = resolutionNodeValue_2.getModule().getFrameDescriptor()) == resolutionNodeValue_2.getModule().getFrameDescriptor() && (bindingName__ = resolutionNodeValue_2.getBindingName()).equals(resolutionNodeValue_2.getBindingName()) && (state_0 & 1) == 0) {
                        s1_ = (CachedData)super.insert((Node)new CachedData());
                        s1_.frameDescriptor_ = frameDescriptor__;
                        s1_.bindingName_ = bindingName__;
                        s1_.readFrameSlot_ = s1_.insertAccessor(JSReadFrameSlotNode.create(frameDescriptor__.findFrameSlot((Object)bindingName__)));
                        this.cached_cache = s1_;
                        this.state_0_ = state_0 |= 1;
                        Cached_duplicateFound_ = true;
                    }
                    if (Cached_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        Object object = ReadImportBindingNode.doCached(resolutionNodeValue_2, s1_.frameDescriptor_, s1_.bindingName_, s1_.readFrameSlot_);
                        return object;
                    }
                }
                this.exclude_ = exclude |= 1;
                this.cached_cache = null;
                state_0 &= 0xFFFFFFFE;
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                Object object = this.doUncached(resolutionNodeValue_2);
                return object;
            }
            if (JSTypes.isDynamicObject(resolutionNodeValue) && JSGuards.isJSModuleNamespace(resolutionNodeValue_ = (DynamicObject)resolutionNodeValue)) {
                this.state_0_ = state_0 |= 4;
                lock.unlock();
                hasLock = false;
                Object object = ReadImportBindingNode.doNamespace(resolutionNodeValue_);
                return object;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.resolutionNode}, new Object[]{resolutionNodeValue});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & state_0 - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        Object[] data = new Object[4];
        data[0] = 0;
        int state_0 = this.state_0_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doCached";
        if ((state_0 & 1) != 0) {
            s[1] = (byte)1;
            ArrayList<List<Object>> cached = new ArrayList<List<Object>>();
            CachedData s1_ = this.cached_cache;
            if (s1_ != null) {
                cached.add(Arrays.asList(s1_.frameDescriptor_, s1_.bindingName_, s1_.readFrameSlot_));
            }
            s[2] = cached;
        } else {
            s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doUncached";
        s[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doNamespace";
        s[1] = (state_0 & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static ReadImportBindingNode create(JavaScriptNode resolutionNode) {
        return new ReadImportBindingNodeGen(resolutionNode);
    }

    @GeneratedBy(value=ReadImportBindingNode.class)
    private static final class CachedData
    extends Node {
        @CompilerDirectives.CompilationFinal
        FrameDescriptor frameDescriptor_;
        @CompilerDirectives.CompilationFinal
        String bindingName_;
        @Node.Child
        JSReadFrameSlotNode readFrameSlot_;

        CachedData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

