/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleStackTraceElement;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSReadFrameSlotNode;
import com.oracle.truffle.js.nodes.access.JSWriteFrameSlotNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.oracle.truffle.js.nodes.control.AsyncGeneratorRejectNode;
import com.oracle.truffle.js.nodes.control.AsyncGeneratorResolveNode;
import com.oracle.truffle.js.nodes.control.AsyncGeneratorResumeNextNode;
import com.oracle.truffle.js.nodes.control.TryCatchNode;
import com.oracle.truffle.js.nodes.function.SpecializedNewObjectNode;
import com.oracle.truffle.js.nodes.promise.AsyncRootNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.objects.AsyncGeneratorRequest;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class AsyncGeneratorBodyNode
extends JavaScriptNode {
    @Node.Child
    private SpecializedNewObjectNode createAsyncGeneratorObject;
    @Node.Child
    private PropertySetNode setGeneratorState;
    @Node.Child
    private PropertySetNode setGeneratorContext;
    @Node.Child
    private PropertySetNode setGeneratorTarget;
    @Node.Child
    private PropertySetNode setGeneratorQueue;
    @CompilerDirectives.CompilationFinal
    volatile RootCallTarget resumeTarget;
    private final JSContext context;
    @Node.Child
    private JavaScriptNode functionBody;
    @Node.Child
    private JSWriteFrameSlotNode writeYieldValueNode;
    @Node.Child
    private JSReadFrameSlotNode readYieldResultNode;
    @Node.Child
    private JSWriteFrameSlotNode writeAsyncContext;
    @Node.Child
    private JSReadFrameSlotNode readAsyncContext;

    public AsyncGeneratorBodyNode(JSContext context, JavaScriptNode body, JSWriteFrameSlotNode writeYieldValueNode, JSReadFrameSlotNode readYieldResultNode, JSWriteFrameSlotNode writeAsyncContext, JSReadFrameSlotNode readAsyncContext) {
        this.createAsyncGeneratorObject = SpecializedNewObjectNode.create(context, false, true, true, true);
        this.setGeneratorState = PropertySetNode.createSetHidden(JSFunction.ASYNC_GENERATOR_STATE_ID, context);
        this.setGeneratorContext = PropertySetNode.createSetHidden(JSFunction.ASYNC_GENERATOR_CONTEXT_ID, context);
        this.setGeneratorTarget = PropertySetNode.createSetHidden(JSFunction.ASYNC_GENERATOR_TARGET_ID, context);
        this.setGeneratorQueue = PropertySetNode.createSetHidden(JSFunction.ASYNC_GENERATOR_QUEUE_ID, context);
        this.context = context;
        this.writeAsyncContext = writeAsyncContext;
        this.functionBody = Objects.requireNonNull(body);
        this.writeYieldValueNode = Objects.requireNonNull(writeYieldValueNode);
        this.readYieldResultNode = Objects.requireNonNull(readYieldResultNode);
        this.readAsyncContext = Objects.requireNonNull(readAsyncContext);
    }

    public static JavaScriptNode create(JSContext context, JavaScriptNode body, JSWriteFrameSlotNode writeYieldValueNode, JSReadFrameSlotNode readYieldResultNode, JSWriteFrameSlotNode writeAsyncContext, JSReadFrameSlotNode readAsyncContext) {
        return new AsyncGeneratorBodyNode(context, body, writeYieldValueNode, readYieldResultNode, writeAsyncContext, readAsyncContext);
    }

    private void initializeCallTarget() {
        CompilerAsserts.neverPartOfCompilation();
        this.atomic(() -> {
            if (this.resumeTarget == null) {
                RootNode rootNode = this.getRootNode();
                AsyncGeneratorRootNode asyncGeneratorRootNode = new AsyncGeneratorRootNode(this.context, this.functionBody, this.writeYieldValueNode, this.readYieldResultNode, this.readAsyncContext, rootNode.getSourceSection(), rootNode.getName());
                this.resumeTarget = Truffle.getRuntime().createCallTarget((RootNode)asyncGeneratorRootNode);
                this.functionBody = null;
                this.writeYieldValueNode = null;
                this.readYieldResultNode = null;
                this.readAsyncContext = null;
            }
        });
    }

    private void ensureCallTargetInitialized() {
        if (this.resumeTarget == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.initializeCallTarget();
        }
    }

    private void asyncGeneratorStart(VirtualFrame frame, DynamicObject generatorObject) {
        MaterializedFrame materializedFrame = frame.materialize();
        this.setGeneratorState.setValue(generatorObject, (Object)JSFunction.AsyncGeneratorState.SuspendedStart);
        this.setGeneratorContext.setValue(generatorObject, materializedFrame);
        this.setGeneratorTarget.setValue(generatorObject, this.resumeTarget);
        this.setGeneratorQueue.setValue(generatorObject, new ArrayDeque(4));
        this.writeAsyncContext.executeWrite(frame, AsyncRootNode.createAsyncContext((CallTarget)this.resumeTarget, generatorObject, materializedFrame));
    }

    @Override
    public Object execute(VirtualFrame frame) {
        this.ensureCallTargetInitialized();
        DynamicObject generatorObject = this.createAsyncGeneratorObject.execute(frame, JSFrameUtil.getFunctionObject((Frame)frame));
        this.asyncGeneratorStart(frame, generatorObject);
        return generatorObject;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return (JavaScriptNode)((Object)this.atomic(() -> {
            if (this.resumeTarget == null) {
                return AsyncGeneratorBodyNode.create(this.context, AsyncGeneratorBodyNode.cloneUninitialized(this.functionBody, materializedTags), AsyncGeneratorBodyNode.cloneUninitialized(this.writeYieldValueNode, materializedTags), AsyncGeneratorBodyNode.cloneUninitialized(this.readYieldResultNode, materializedTags), AsyncGeneratorBodyNode.cloneUninitialized(this.writeAsyncContext, materializedTags), AsyncGeneratorBodyNode.cloneUninitialized(this.readAsyncContext, materializedTags));
            }
            AsyncGeneratorRootNode generatorRoot = (AsyncGeneratorRootNode)this.resumeTarget.getRootNode();
            return AsyncGeneratorBodyNode.create(this.context, AsyncGeneratorBodyNode.cloneUninitialized(generatorRoot.functionBody, materializedTags), AsyncGeneratorBodyNode.cloneUninitialized(generatorRoot.writeYieldValue, materializedTags), AsyncGeneratorBodyNode.cloneUninitialized(generatorRoot.readYieldResult, materializedTags), AsyncGeneratorBodyNode.cloneUninitialized(this.writeAsyncContext, materializedTags), AsyncGeneratorBodyNode.cloneUninitialized(this.readAsyncContext, materializedTags));
        }));
    }

    @NodeInfo(cost=NodeCost.NONE, language="JavaScript", description="The root node of async generator functions in JavaScript.")
    private static final class AsyncGeneratorRootNode
    extends JavaScriptRootNode
    implements AsyncRootNode {
        private static final int ASYNC_FRAME_ARG_INDEX = 0;
        @Node.Child
        private PropertySetNode setGeneratorState;
        @Node.Child
        private JavaScriptNode functionBody;
        @Node.Child
        private JSWriteFrameSlotNode writeYieldValue;
        @Node.Child
        private JSReadFrameSlotNode readYieldResult;
        @Node.Child
        private JSReadFrameSlotNode readAsyncContext;
        @Node.Child
        private AsyncGeneratorResolveNode asyncGeneratorResolveNode;
        @Node.Child
        private AsyncGeneratorRejectNode asyncGeneratorRejectNode;
        @Node.Child
        private AsyncGeneratorResumeNextNode asyncGeneratorResumeNextNode;
        @Node.Child
        private TryCatchNode.GetErrorObjectNode getErrorObjectNode;
        @Node.Child
        private InteropLibrary exceptions;
        private final JSContext context;
        private final String functionName;

        AsyncGeneratorRootNode(JSContext context, JavaScriptNode functionBody, JSWriteFrameSlotNode writeYieldValueNode, JSReadFrameSlotNode readYieldResultNode, JSReadFrameSlotNode readAsyncContext, SourceSection functionSourceSection, String functionName) {
            super(context.getLanguage(), functionSourceSection, null);
            this.readAsyncContext = readAsyncContext;
            this.functionName = functionName;
            this.setGeneratorState = PropertySetNode.createSetHidden(JSFunction.ASYNC_GENERATOR_STATE_ID, context);
            this.functionBody = functionBody;
            this.writeYieldValue = writeYieldValueNode;
            this.readYieldResult = readYieldResultNode;
            this.context = context;
            this.asyncGeneratorResolveNode = AsyncGeneratorResolveNode.create(context);
            this.asyncGeneratorResumeNextNode = AsyncGeneratorResumeNextNode.createTailCall(context);
        }

        /*
         * Exception decompiling
         */
        public Object execute(VirtualFrame frame) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private boolean shouldCatch(Throwable exception) {
            if (this.getErrorObjectNode == null || this.asyncGeneratorRejectNode == null || this.exceptions == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getErrorObjectNode = (TryCatchNode.GetErrorObjectNode)this.insert(TryCatchNode.GetErrorObjectNode.create(this.context));
                this.asyncGeneratorRejectNode = (AsyncGeneratorRejectNode)this.insert(AsyncGeneratorRejectNode.create(this.context));
                this.exceptions = (InteropLibrary)this.insert((Node)InteropLibrary.getFactory().createDispatched(5));
            }
            return TryCatchNode.shouldCatch(exception, this.exceptions);
        }

        @Override
        public boolean isResumption() {
            return true;
        }

        public String getName() {
            if (this.functionName != null && !this.functionName.isEmpty()) {
                return this.functionName;
            }
            return ":asyncgenerator";
        }

        public String toString() {
            return this.getName();
        }

        @Override
        public DynamicObject getAsyncFunctionPromise(Frame asyncFrame) {
            Object[] initialState = (Object[])this.readAsyncContext.execute((VirtualFrame)asyncFrame);
            RootCallTarget resumeTarget = (RootCallTarget)initialState[0];
            assert (resumeTarget.getRootNode() == this);
            DynamicObject generatorObject = (DynamicObject)initialState[1];
            Object queue = JSObjectUtil.getHiddenProperty(generatorObject, JSFunction.ASYNC_GENERATOR_QUEUE_ID);
            if (queue instanceof ArrayDeque && ((ArrayDeque)queue).size() == 1) {
                AsyncGeneratorRequest request = (AsyncGeneratorRequest)((ArrayDeque)queue).peekFirst();
                return request.getPromiseCapability().getPromise();
            }
            return null;
        }

        public List<TruffleStackTraceElement> getSavedStackTrace(Frame asyncFrame) {
            Object[] initialState = (Object[])this.readAsyncContext.execute((VirtualFrame)asyncFrame);
            return (List)initialState[3];
        }

        protected List<TruffleStackTraceElement> findAsynchronousFrames(Frame frame) {
            if (!this.context.isOptionAsyncStackTraces() || this.context.getLanguage().getAsyncStackDepth() == 0) {
                return null;
            }
            Object frameArg = frame.getArguments()[0];
            Object asyncFrame = frameArg instanceof MaterializedFrame ? (MaterializedFrame)frameArg : (VirtualFrame)ScopeFrameNode.getNonBlockScopeParentFrame(frame);
            return this.getSavedStackTrace((Frame)asyncFrame);
        }
    }
}

