/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.JavaBuiltinsFactory;
import com.oracle.truffle.js.nodes.access.RealmNode;
import com.oracle.truffle.js.nodes.access.WriteElementNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectArrayNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.interop.ExportValueNode;
import com.oracle.truffle.js.nodes.interop.ImportValueNode;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.java.JavaAccess;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.List;

public final class JavaBuiltins
extends JSBuiltinsContainer.SwitchEnum<Java> {
    public static final JSBuiltinsContainer BUILTINS = new JavaBuiltins();
    public static final JSBuiltinsContainer BUILTINS_NASHORN_COMPAT = new JavaNashornCompatBuiltins();

    protected JavaBuiltins() {
        super("Java", Java.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, Java builtinEnum) {
        switch (builtinEnum) {
            case type: {
                return JavaBuiltinsFactory.JavaTypeNodeGen.create(context, builtin, JavaBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case typeName: {
                return JavaBuiltinsFactory.JavaTypeNameNodeGen.create(context, builtin, JavaBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case from: {
                return JavaBuiltinsFactory.JavaFromNodeGen.create(context, builtin, JavaBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case to: {
                return JavaBuiltinsFactory.JavaToNodeGen.create(context, builtin, JavaBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case isType: {
                return JavaBuiltinsFactory.JavaIsTypeNodeGen.create(context, builtin, JavaBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case isJavaObject: {
                return JavaBuiltinsFactory.JavaIsJavaObjectNodeGen.create(context, builtin, JavaBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case addToClasspath: {
                return JavaBuiltinsFactory.JavaAddToClasspathNodeGen.create(context, builtin, JavaBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case extend: {
                if (JSConfig.SubstrateVM) break;
                return JavaBuiltinsFactory.JavaExtendNodeGen.create(context, builtin, JavaBuiltins.args().varArgs().createArgumentNodes(context));
            }
            case super_: {
                if (JSConfig.SubstrateVM) break;
                return JavaBuiltinsFactory.JavaSuperNodeGen.create(context, builtin, JavaBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    static abstract class JavaAddToClasspathNode
    extends JSBuiltinNode {
        JavaAddToClasspathNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object doString(String fileName) {
            TruffleLanguage.Env env = this.getContext().getRealm().getEnv();
            try {
                TruffleFile file = env.getPublicTruffleFile(fileName);
                env.addToHostClassPath(file);
            }
            catch (SecurityException e) {
                throw Errors.createErrorFromException(e);
            }
            return Undefined.instance;
        }

        @Specialization(replaces={"doString"})
        protected Object doObject(Object fileName, @Cached(value="create()") JSToStringNode toStringNode) {
            return this.doString(toStringNode.executeString(fileName));
        }
    }

    static abstract class JavaSynchronizedNode
    extends JSBuiltinNode {
        @Node.Child
        private RealmNode realmNode;

        JavaSynchronizedNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.realmNode = RealmNode.create(context);
        }

        @Specialization
        protected Object doSynchronize(VirtualFrame frame, Object func, Object lock) {
            if (!JSFunction.isJSFunction(func)) {
                throw Errors.createTypeErrorNotAFunction(func);
            }
            if (lock != Undefined.instance) {
                JavaSynchronizedNode.unwrapAndCheckLockObject(lock, this.getContext().getRealm().getEnv());
            }
            JSRealm realm = this.realmNode.execute(frame);
            JSFunctionData synchronizedFunctionData = this.createSynchronizedWrapper((DynamicObject)func);
            DynamicObject synchronizedFunction = JSFunction.create(realm, synchronizedFunctionData);
            if (lock != Undefined.instance) {
                return JSFunction.bind(realm, synchronizedFunction, lock, JSArguments.EMPTY_ARGUMENTS_ARRAY);
            }
            return synchronizedFunction;
        }

        @CompilerDirectives.TruffleBoundary
        private JSFunctionData createSynchronizedWrapper(final DynamicObject func) {
            final JSContext context = this.getContext();
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)new JavaScriptRootNode(context.getLanguage(), null, null){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object execute(VirtualFrame frame) {
                    Object thisObj = JSFrameUtil.getThisObj((Frame)frame);
                    Object lock = JavaSynchronizedNode.unwrapAndCheckLockObject(thisObj, context.getRealm().getEnv());
                    Object[] arguments = JSArguments.create(thisObj, func, JSArguments.extractUserArguments(frame.getArguments()));
                    Object object = lock;
                    synchronized (object) {
                        return JSFunction.call(arguments);
                    }
                }
            });
            return JSFunctionData.createCallOnly(context, (CallTarget)callTarget, 0, "synchronizedWrapper");
        }

        static Object unwrapJavaObject(Object object, TruffleLanguage.Env env) {
            if (env.isHostObject(object)) {
                return env.asHostObject(object);
            }
            return object;
        }

        static Object unwrapAndCheckLockObject(Object thisObj, TruffleLanguage.Env env) {
            Object lock = JavaSynchronizedNode.unwrapJavaObject(thisObj, env);
            if (JSRuntime.isJSPrimitive(lock) || lock.getClass().isArray()) {
                CompilerDirectives.transferToInterpreter();
                throw Errors.createTypeError("Locking not supported on type: " + lock.getClass().getTypeName());
            }
            return lock;
        }
    }

    static abstract class JavaIsScriptObjectNode
    extends JSBuiltinNode {
        JavaIsScriptObjectNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected static boolean isScriptObject(Object obj) {
            return JSDynamicObject.isJSDynamicObject(obj);
        }
    }

    static abstract class JavaIsScriptFunctionNode
    extends JSBuiltinNode {
        JavaIsScriptFunctionNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected static boolean isScriptFunction(Object obj) {
            return JSFunction.isJSFunction(obj);
        }
    }

    static abstract class JavaIsJavaFunctionNode
    extends JSBuiltinNode {
        JavaIsJavaFunctionNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean isJavaFunction(Object obj) {
            TruffleLanguage.Env env = this.getContext().getRealm().getEnv();
            return env.isHostFunction(obj) || env.isHostObject(obj) && env.asHostObject(obj) instanceof Class;
        }
    }

    static abstract class JavaIsJavaMethodNode
    extends JSBuiltinNode {
        JavaIsJavaMethodNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean isJavaMethod(Object obj) {
            TruffleLanguage.Env env = this.getContext().getRealm().getEnv();
            return env.isHostFunction(obj);
        }
    }

    static abstract class JavaIsJavaObject
    extends JSBuiltinNode {
        JavaIsJavaObject(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected final boolean isJavaObject(Object obj) {
            TruffleLanguage.Env env = this.getContext().getRealm().getEnv();
            return env.isHostObject(obj) || env.isHostFunction(obj);
        }
    }

    static abstract class JavaIsTypeNode
    extends JSBuiltinNode {
        JavaIsTypeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected final boolean isType(Object obj) {
            TruffleLanguage.Env env = this.getContext().getRealm().getEnv();
            return env.isHostObject(obj) && env.asHostObject(obj) instanceof Class;
        }
    }

    static abstract class JavaSuperNode
    extends JSBuiltinNode {
        JavaSuperNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected Object superAdapter(Object adapter) {
            try {
                return InteropLibrary.getUncached().readMember(adapter, "super");
            }
            catch (UnknownIdentifierException | UnsupportedMessageException e) {
                return Undefined.instance;
            }
        }
    }

    @ImportStatic(value={JSConfig.class})
    static abstract class JavaToNode
    extends JSBuiltinNode {
        @Node.Child
        private JSToObjectArrayNode toObjectArrayNode;
        @Node.Child
        private ExportValueNode exportValue;
        @Node.Child
        private InteropLibrary newArray;
        @Node.Child
        private InteropLibrary arrayElements;
        @Node.Child
        private JSToStringNode toStringNode;

        JavaToNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.toObjectArrayNode = JSToObjectArrayNode.create(context);
            this.exportValue = ExportValueNode.create();
            this.newArray = (InteropLibrary)InteropLibrary.getFactory().createDispatched(5);
            this.arrayElements = (InteropLibrary)InteropLibrary.getFactory().createDispatched(5);
        }

        private String toString(Object target) {
            if (this.toStringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toStringNode = (JSToStringNode)this.insert(JSToStringNode.create());
            }
            return this.toStringNode.executeString(target);
        }

        @Specialization(guards={"isJSObject(jsObj)"})
        protected Object to(Object jsObj, Object toType) {
            TruffleLanguage.Env env = this.getContext().getRealm().getEnv();
            if (env.isHostObject(toType)) {
                if (JavaToNode.isJavaArrayClass(toType, env)) {
                    return this.toArray(jsObj, toType, env);
                }
                throw Errors.createTypeErrorFormat("Unsupported type: %s", toType);
            }
            if (toType == Undefined.instance) {
                return this.toArray(jsObj, env.asGuestValue(Object[].class), env);
            }
            String className = this.toString(toType);
            Object javaType = JavaTypeNode.lookupJavaType(className, env);
            if (JavaToNode.isJavaArrayClass(javaType, env)) {
                return this.toArray(jsObj, javaType, env);
            }
            throw Errors.createTypeErrorFormat("Unsupported type: %s", className);
        }

        @Specialization(guards={"!isJSObject(obj)"}, limit="InteropLibraryLimit")
        protected Object toNonObject(Object obj, Object toType, @CachedLibrary(value="obj") InteropLibrary interop) {
            if (interop.hasArrayElements(obj)) {
                return this.to(obj, toType);
            }
            throw Errors.createTypeErrorNotAnObject(obj);
        }

        private static boolean isJavaArrayClass(Object obj, TruffleLanguage.Env env) {
            if (env.isHostObject(obj)) {
                Object javaObj = env.asHostObject(obj);
                return javaObj instanceof Class && ((Class)javaObj).isArray();
            }
            return false;
        }

        private Object toArray(Object jsObj, Object arrayType, TruffleLanguage.Env env) {
            assert (JavaToNode.isJavaArrayClass(arrayType, env));
            Object[] arr = this.toObjectArrayNode.executeObjectArray(jsObj);
            try {
                Object result = this.newArray.instantiate(arrayType, new Object[]{arr.length});
                for (int i = 0; i < arr.length; ++i) {
                    this.arrayElements.writeArrayElement(result, (long)i, this.exportValue.execute(arr[i]));
                }
                return result;
            }
            catch (ArityException | InvalidArrayIndexException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw Errors.createTypeError(Boundaries.javaToString(e));
            }
        }
    }

    static abstract class JavaFromNode
    extends JSBuiltinNode {
        private final BranchProfile objectListBranch = BranchProfile.create();
        private final BranchProfile needErrorBranches = BranchProfile.create();
        @Node.Child
        private WriteElementNode writeNode;
        @Node.Child
        private ImportValueNode foreignConvertNode;
        @Node.Child
        private InteropLibrary interop = (InteropLibrary)InteropLibrary.getFactory().createDispatched(5);

        JavaFromNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        private void write(Object target, int index, Object value) {
            if (this.writeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeNode = (WriteElementNode)this.insert(WriteElementNode.create(null, null, null, this.getContext(), false));
            }
            this.writeNode.executeWithTargetAndIndexAndValue(target, index, value);
        }

        private Object foreignConvert(Object value) {
            if (this.foreignConvertNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.foreignConvertNode = (ImportValueNode)this.insert(ImportValueNode.create());
            }
            return this.foreignConvertNode.executeWithTarget(value);
        }

        @Specialization
        protected DynamicObject from(Object javaArray) {
            block5: {
                TruffleLanguage.Env env = this.getContext().getRealm().getEnv();
                if (env.isHostObject(javaArray)) {
                    try {
                        long size = this.interop.getArraySize(javaArray);
                        if (size < 0L || size >= Integer.MAX_VALUE) {
                            throw Errors.createRangeErrorInvalidArrayLength();
                        }
                        DynamicObject jsArray = JSArray.createEmptyChecked(this.getContext(), size);
                        int i = 0;
                        while ((long)i < size) {
                            Object element = this.foreignConvert(this.interop.readArrayElement(javaArray, (long)i));
                            this.write(jsArray, i, element);
                            ++i;
                        }
                        return jsArray;
                    }
                    catch (InvalidArrayIndexException | UnsupportedMessageException size) {
                        Object hostObject = env.asHostObject(javaArray);
                        if (!(hostObject instanceof List)) break block5;
                        List javaList = (List)hostObject;
                        int len = Boundaries.listSize(javaList);
                        DynamicObject jsArrayObj = JSArray.createEmptyChecked(this.getContext(), (long)len);
                        this.fromList(javaList, len, jsArrayObj);
                        return jsArrayObj;
                    }
                }
            }
            this.needErrorBranches.enter();
            throw Errors.createTypeError("Cannot convert to JavaScript array.");
        }

        private void fromList(List<?> javaList, int len, DynamicObject jsArrayObj) {
            this.objectListBranch.enter();
            for (int i = 0; i < len; ++i) {
                this.write(jsArrayObj, i, this.foreignConvert(Boundaries.listGet(javaList, i)));
            }
        }
    }

    static abstract class JavaExtendNode
    extends JSBuiltinNode {
        private final BranchProfile errorBranch = BranchProfile.create();

        JavaExtendNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
        protected Object extend(Object[] arguments) {
            int typesLength;
            DynamicObject classOverrides;
            if (JSConfig.SubstrateVM) {
                throw Errors.unsupported("JavaAdapter");
            }
            if (arguments.length == 0) {
                this.errorBranch.enter();
                throw Errors.createTypeError("Java.extend needs at least one argument.");
            }
            if (JSRuntime.isObject(arguments[arguments.length - 1])) {
                classOverrides = (DynamicObject)arguments[arguments.length - 1];
                typesLength = arguments.length - 1;
                if (typesLength == 0) {
                    this.errorBranch.enter();
                    throw Errors.createTypeError("Java.extend needs at least one type argument.");
                }
            } else {
                classOverrides = null;
                typesLength = arguments.length;
            }
            TruffleLanguage.Env env = this.getContext().getRealm().getEnv();
            Class[] types = new Class[typesLength];
            for (int i = 0; i < typesLength; ++i) {
                if (!JavaExtendNode.isType(arguments[i], env)) {
                    this.errorBranch.enter();
                    throw Errors.createTypeError("Java.extend needs Java types as its arguments.");
                }
                types[i] = JavaExtendNode.toHostClass(arguments[i], env);
            }
            try {
                JavaAccess.checkAccess(types, this.getContext());
                if (classOverrides != null) {
                    return env.createHostAdapterClassWithStaticOverrides(types, (Object)classOverrides);
                }
                return env.createHostAdapterClass(types);
            }
            catch (Exception ex) {
                throw Errors.createTypeError(ex.getMessage(), ex, this);
            }
        }

        protected static boolean isType(Object obj, TruffleLanguage.Env env) {
            return env.isHostObject(obj) && env.asHostObject(obj) instanceof Class;
        }

        protected static Class<?> toHostClass(Object type, TruffleLanguage.Env env) {
            assert (JavaExtendNode.isType(type, env));
            return (Class)env.asHostObject(type);
        }
    }

    static abstract class JavaTypeNameNode
    extends JSBuiltinNode {
        JavaTypeNameNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJavaInteropClass(type)"})
        protected String typeNameJavaInteropClass(Object type) {
            TruffleLanguage.Env env = this.getContext().getRealm().getEnv();
            return ((Class)env.asHostObject(type)).getName();
        }

        @Fallback
        protected Object nonType(Object value) {
            return Undefined.instance;
        }

        protected final boolean isJavaInteropClass(Object obj) {
            TruffleLanguage.Env env = this.getContext().getRealm().getEnv();
            return env.isHostObject(obj) && env.asHostObject(obj) instanceof Class;
        }
    }

    static abstract class JavaTypeNode
    extends JSBuiltinNode {
        JavaTypeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected Object type(String name) {
            TruffleLanguage.Env env = this.getContext().getRealm().getEnv();
            Object javaType = JavaTypeNode.lookupJavaType(name, env);
            if (javaType == null) {
                throw Errors.createTypeErrorClassNotFound(name);
            }
            return javaType;
        }

        @Specialization(guards={"!isString(obj)"})
        protected Object typeNoString(Object obj) {
            throw Errors.createTypeError("Java.type expects one string argument");
        }

        @CompilerDirectives.TruffleBoundary
        static Object lookupJavaType(String name, TruffleLanguage.Env env) {
            if (env != null && env.isHostLookupAllowed()) {
                try {
                    Object found = env.lookupHostSymbol(name);
                    if (found != null) {
                        return found;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return JavaTypeNode.lookForSubclasses(name, env);
            }
            throw Errors.createTypeError("Java Interop is not available");
        }

        private static Object lookForSubclasses(String className, TruffleLanguage.Env env) {
            StringBuilder nextName = new StringBuilder(className);
            int lastDot = nextName.length();
            while ((lastDot = nextName.lastIndexOf(".", lastDot - 1)) != -1) {
                nextName.setCharAt(lastDot, '$');
                try {
                    String innerClassName = nextName.toString();
                    Object found = env.lookupHostSymbol(innerClassName);
                    if (found == null) continue;
                    return found;
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
            return null;
        }
    }

    public static final class JavaNashornCompatBuiltins
    extends JSBuiltinsContainer.SwitchEnum<JavaNashornCompat> {
        protected JavaNashornCompatBuiltins() {
            super("JavaNashornCompat", JavaNashornCompat.class);
        }

        @Override
        protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, JavaNashornCompat builtinEnum) {
            switch (builtinEnum) {
                case isJavaMethod: {
                    return JavaBuiltinsFactory.JavaIsJavaMethodNodeGen.create(context, builtin, JavaNashornCompatBuiltins.args().fixedArgs(1).createArgumentNodes(context));
                }
                case isJavaFunction: {
                    return JavaBuiltinsFactory.JavaIsJavaFunctionNodeGen.create(context, builtin, JavaNashornCompatBuiltins.args().fixedArgs(1).createArgumentNodes(context));
                }
                case isScriptFunction: {
                    return JavaBuiltinsFactory.JavaIsScriptFunctionNodeGen.create(context, builtin, JavaNashornCompatBuiltins.args().fixedArgs(1).createArgumentNodes(context));
                }
                case isScriptObject: {
                    return JavaBuiltinsFactory.JavaIsScriptObjectNodeGen.create(context, builtin, JavaNashornCompatBuiltins.args().fixedArgs(1).createArgumentNodes(context));
                }
                case synchronized_: {
                    if (JSConfig.SubstrateVM) break;
                    return JavaBuiltinsFactory.JavaSynchronizedNodeGen.create(context, builtin, JavaNashornCompatBuiltins.args().fixedArgs(2).createArgumentNodes(context));
                }
            }
            return null;
        }

        public static enum JavaNashornCompat implements BuiltinEnum<JavaNashornCompat>
        {
            isJavaMethod(1),
            isJavaFunction(1),
            isScriptFunction(1),
            isScriptObject(1),
            synchronized_(2){

                @Override
                public boolean isAOTSupported() {
                    return false;
                }
            };

            private final int length;

            private JavaNashornCompat(int length) {
                this.length = length;
            }

            @Override
            public int getLength() {
                return this.length;
            }
        }
    }

    public static enum Java implements BuiltinEnum<Java>
    {
        type(1),
        from(1),
        to(2),
        isJavaObject(1),
        isType(1),
        typeName(1),
        addToClasspath(1),
        extend(1){

            @Override
            public boolean isAOTSupported() {
                return false;
            }
        }
        ,
        super_(1){

            @Override
            public boolean isAOTSupported() {
                return false;
            }
        };

        private final int length;

        private Java(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }
}

