/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.configuration.localisation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import org.phoenicis.configuration.localisation.LocalisationHelper;
import org.phoenicis.configuration.localisation.PropertiesResourceBundle;
import org.phoenicis.configuration.localisation.Translatable;
import org.phoenicis.configuration.localisation.TranslatableBuilder;
import org.phoenicis.configuration.localisation.TranslatableCreator;
import org.phoenicis.configuration.localisation.Translate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class Localisation {
    private static final Logger LOGGER = LoggerFactory.getLogger(Localisation.class);
    private static final LocalisationHelper localisationHelper = new LocalisationHelper();
    private static I18n i18n = null;

    private Localisation() {
    }

    private static I18n getI18n() {
        if (i18n == null) {
            i18n = I18nFactory.getI18n(Localisation.class, (String)"Messages");
        }
        return i18n;
    }

    public static void setAdditionalTranslations(PropertiesResourceBundle resourceBundle) {
        resourceBundle.setParent(Localisation.getI18n().getResources());
        Localisation.getI18n().setResources((ResourceBundle)resourceBundle);
    }

    private static String trString(String text) {
        return text == null ? null : Localisation.getI18n().tr(text);
    }

    public static String tr(String text, Object o1) {
        return text == null ? null : Localisation.getI18n().tr(text, o1);
    }

    public static String tr(String text, Object o1, Object o2) {
        return text == null ? null : Localisation.getI18n().tr(text, o1, o2);
    }

    public static String tr(String text, Object o1, Object o2, Object o3) {
        return text == null ? null : Localisation.getI18n().tr(text, o1, o2, o3);
    }

    public static String tr(String text, Object o1, Object o2, Object o3, Object o4) {
        return text == null ? null : Localisation.getI18n().tr(text, o1, o2, o3, o4);
    }

    public static String tr(String text, Object[] objects) {
        return text == null ? null : Localisation.getI18n().tr(text, objects);
    }

    public static <T> T tr(T translatable) {
        if (translatable == null) {
            return null;
        }
        if (translatable instanceof String) {
            String translateResult = Localisation.trString(translatable.toString());
            return (T)translateResult;
        }
        if (translatable instanceof List) {
            List<T> translateResult = Localisation.trList((List)translatable);
            return (T)translateResult;
        }
        if (translatable instanceof Set) {
            Set<T> translateResult = Localisation.trSet((Set)translatable);
            return (T)translateResult;
        }
        Class<?> clazz = translatable.getClass();
        Optional<Constructor<?>> translateCreator = Localisation.findTranslateCreator(clazz);
        Optional<Class<?>> translateBuilder = Localisation.findTranslateBuilder(clazz);
        try {
            if (translateCreator.isPresent()) {
                return Localisation.trFromTranslateCreator(translatable, translateCreator.get());
            }
            if (translateBuilder.isPresent()) {
                return Localisation.trFromTranslateBuilder(translatable, translateBuilder.get());
            }
        }
        catch (ReflectiveOperationException e) {
            LOGGER.warn("Error while translating " + translatable + ". Falling back to the original value", (Throwable)e);
        }
        LOGGER.warn(translatable + " is neither a String, neither a collection, neither translatable. Ignoring");
        return translatable;
    }

    public static boolean isTranslatable(Class<?> clazz) {
        for (Annotation annotation : clazz.getAnnotations()) {
            if (annotation.annotationType() != Translatable.class) continue;
            return true;
        }
        return false;
    }

    private static <T> List<T> trList(List<T> translatable) {
        return translatable.stream().map(Localisation::tr).collect(Collectors.toList());
    }

    private static <T> Set<T> trSet(Set<T> translatable) {
        return translatable.stream().map(Localisation::tr).collect(Collectors.toSet());
    }

    private static <T> T trFromTranslateCreator(T translatable, Constructor<?> translateCreator) throws ReflectiveOperationException {
        ArrayList<Object> parameters = new ArrayList<Object>();
        for (Parameter parameter : translateCreator.getParameters()) {
            Method getter = Localisation.findSuitableGetter(translatable, parameter);
            Object getterResult = getter.invoke(translatable, new Object[0]);
            if (Localisation.shouldBeTranslated(getter)) {
                parameters.add(Localisation.tr(getterResult));
                continue;
            }
            parameters.add(getterResult);
        }
        Object result = translateCreator.newInstance(parameters.toArray());
        return (T)result;
    }

    private static <T> T trFromTranslateBuilder(T translatable, Class<?> builderClass) throws ReflectiveOperationException {
        Object builder = builderClass.newInstance();
        for (Method method : builderClass.getMethods()) {
            if (!method.getName().startsWith("with")) continue;
            Method getter = translatable.getClass().getMethod(localisationHelper.getterNameFromBuilderMethod(method), new Class[0]);
            Object getterResult = getter.invoke(translatable, new Object[0]);
            if (Localisation.shouldBeTranslated(getter)) {
                method.invoke(builder, Localisation.tr(getterResult));
                continue;
            }
            method.invoke(builder, getterResult);
        }
        Object result = builderClass.getMethod("build", new Class[0]).invoke(builder, new Object[0]);
        return (T)result;
    }

    private static boolean shouldBeTranslated(Method getter) {
        return getter.getAnnotation(Translate.class) != null;
    }

    private static <T> Method findSuitableGetter(T object, Parameter parameter) throws ReflectiveOperationException {
        return object.getClass().getMethod(localisationHelper.getterNameFromParameter(parameter), new Class[0]);
    }

    private static Optional<Constructor<?>> findTranslateCreator(Class<?> clazz) {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            for (Annotation annotation : constructor.getAnnotations()) {
                if (annotation.annotationType() != TranslatableCreator.class) continue;
                return Optional.of(constructor);
            }
        }
        return Optional.empty();
    }

    private static Optional<Class<?>> findTranslateBuilder(Class<?> clazz) {
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            Annotation[] annotations;
            List parameterTypes = Arrays.stream(constructor.getParameterTypes()).filter(s -> s.getName().contains("Builder")).collect(Collectors.toList());
            if (parameterTypes.size() <= 0) continue;
            for (Annotation annotation : annotations = ((Class)parameterTypes.get(0)).getAnnotations()) {
                if (annotation.annotationType() != TranslatableBuilder.class) continue;
                return Optional.of((Class)parameterTypes.get(0));
            }
        }
        return Optional.empty();
    }
}

