/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.containers.dto;

import java.util.List;
import org.phoenicis.containers.dto.ContainerDTO;
import org.phoenicis.library.dto.ShortcutDTO;

public class WinePrefixContainerDTO
extends ContainerDTO {
    private final String architecture;
    private final String distribution;
    private final String version;

    private WinePrefixContainerDTO(Builder builder) {
        super(builder.name, builder.path, ContainerDTO.ContainerType.WINEPREFIX, "Wine", builder.installedShortcuts);
        this.architecture = builder.architecture;
        this.distribution = builder.distribution;
        this.version = builder.version;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public String getDistribution() {
        return this.distribution;
    }

    public String getVersion() {
        return this.version;
    }

    public static class Builder {
        private String name;
        private String path;
        private String architecture;
        private String distribution;
        private String version;
        private List<ShortcutDTO> installedShortcuts;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withPath(String path) {
            this.path = path;
            return this;
        }

        public Builder withInstalledShortcuts(List<ShortcutDTO> installedShortcuts) {
            this.installedShortcuts = installedShortcuts;
            return this;
        }

        public Builder withArchitecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        public Builder withDistribution(String distribution) {
            this.distribution = distribution;
            return this;
        }

        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        public ContainerDTO build() {
            return new WinePrefixContainerDTO(this);
        }
    }
}

