/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.containers.dto;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.phoenicis.containers.dto.ContainerDTO;

@JsonDeserialize(builder=Builder.class)
public class ContainerCategoryDTO {
    private final String name;
    private final String description;
    private final List<ContainerDTO> containers;
    private URI icon;

    private ContainerCategoryDTO(Builder builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.containers = Collections.unmodifiableList(builder.containers);
        this.icon = builder.icon;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<ContainerDTO> getContainers() {
        return this.containers;
    }

    public URI getIcon() {
        return this.icon;
    }

    public static Comparator<ContainerDTO> nameComparator() {
        return (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName());
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.name).toString();
    }

    @JsonPOJOBuilder(buildMethodName="build", withPrefix="with")
    public static class Builder {
        private String name;
        private String description;
        private List<ContainerDTO> containers = new ArrayList<ContainerDTO>();
        private URI icon;

        public Builder() {
        }

        public Builder(ContainerCategoryDTO categoryDTO) {
            this.withName(categoryDTO.getName()).withDescription(categoryDTO.getDescription()).withContainers(categoryDTO.getContainers()).withIcon(categoryDTO.getIcon());
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withContainers(List<ContainerDTO> containers) {
            this.containers = containers;
            return this;
        }

        public Builder withIcon(URI iconPath) {
            this.icon = iconPath;
            return this;
        }

        public ContainerCategoryDTO build() {
            return new ContainerCategoryDTO(this);
        }
    }
}

