/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.containers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.graalvm.polyglot.Value;
import org.phoenicis.configuration.security.Safe;
import org.phoenicis.containers.ContainersManager;
import org.phoenicis.containers.dto.ContainerCategoryDTO;
import org.phoenicis.containers.dto.ContainerDTO;
import org.phoenicis.containers.dto.WinePrefixContainerDTO;
import org.phoenicis.library.LibraryManager;
import org.phoenicis.library.ShortcutManager;
import org.phoenicis.library.ShortcutReader;
import org.phoenicis.library.dto.ShortcutDTO;
import org.phoenicis.scripts.interpreter.ScriptInterpreter;
import org.phoenicis.scripts.session.InteractiveScriptSession;
import org.phoenicis.tools.config.CompatibleConfigFileFormatFactory;
import org.phoenicis.tools.config.ConfigFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@Safe
public class GenericContainersManager
implements ContainersManager {
    private final Logger LOGGER = LoggerFactory.getLogger(GenericContainersManager.class);
    @org.springframework.beans.factory.annotation.Value(value="${application.user.containers}")
    private String containersPath;
    private final CompatibleConfigFileFormatFactory compatibleConfigFileFormatFactory;
    private final LibraryManager libraryManager;
    private final ShortcutManager shortcutManager;
    private final ScriptInterpreter scriptInterpreter;
    private ObjectMapper objectMapper;

    public GenericContainersManager(CompatibleConfigFileFormatFactory compatibleConfigFileFormatFactory, LibraryManager libraryManager, ShortcutManager shortcutManager, ScriptInterpreter scriptInterpreter, ObjectMapper objectMapper) {
        this.compatibleConfigFileFormatFactory = compatibleConfigFileFormatFactory;
        this.libraryManager = libraryManager;
        this.shortcutManager = shortcutManager;
        this.scriptInterpreter = scriptInterpreter;
        this.objectMapper = objectMapper;
    }

    @Override
    public void fetchContainers(Consumer<List<ContainerCategoryDTO>> onSuccess, Consumer<Exception> onError) {
        File containersFile = new File(this.containersPath);
        containersFile.mkdirs();
        File[] engineDirectories = containersFile.listFiles();
        if (engineDirectories == null) {
            onSuccess.accept(Collections.emptyList());
        } else {
            ArrayList<ContainerCategoryDTO> containerCategories = new ArrayList<ContainerCategoryDTO>();
            for (File engineDirectory : engineDirectories) {
                List<ContainerDTO> containers = this.fetchContainers(engineDirectory);
                if (CollectionUtils.isEmpty(containers)) continue;
                containerCategories.add(new ContainerCategoryDTO.Builder().withName(engineDirectory.getName()).withContainers(containers).build());
            }
            onSuccess.accept(containerCategories);
        }
    }

    @Override
    public void deleteContainer(ContainerDTO container, Consumer<ContainerDTO> onSuccess, Consumer<Exception> onError) {
        try {
            File containerFile = new File(container.getPath());
            FileUtils.deleteDirectory((File)containerFile);
        }
        catch (IOException e) {
            this.LOGGER.error("Cannot delete container (" + container.getPath() + ")! Exception: " + e.toString());
            onError.accept(e);
        }
        String engineId = container.getEngine().toLowerCase();
        List categories = this.libraryManager.fetchShortcuts();
        categories.stream().flatMap(shortcutCategory -> shortcutCategory.getShortcuts().stream()).forEach(shortcut -> {
            InteractiveScriptSession interactiveScriptSession = this.scriptInterpreter.createInteractiveSession();
            interactiveScriptSession.eval("include(\"engines." + engineId + ".shortcuts.reader\");", result -> {
                Value shortcutReaderClass = (Value)result;
                ShortcutReader shortcutReader = (ShortcutReader)shortcutReaderClass.newInstance(new Object[0]).as(ShortcutReader.class);
                shortcutReader.of(shortcut);
                String containerName = shortcutReader.getContainer();
                if (containerName.equals(container.getName())) {
                    this.shortcutManager.deleteShortcut(shortcut);
                }
            }, onError);
        });
        onSuccess.accept(container);
    }

    private List<ContainerDTO> fetchContainers(File directory) {
        ArrayList<ContainerDTO> containers = new ArrayList<ContainerDTO>();
        File[] containerDirectories = directory.listFiles();
        if (containerDirectories != null) {
            for (File containerDirectory : containerDirectories) {
                if (containerDirectory.isHidden()) continue;
                ConfigFile configFile = this.compatibleConfigFileFormatFactory.open(new File(containerDirectory, "phoenicis.cfg"));
                String containerPath = containerDirectory.getAbsolutePath();
                String containerName = containerPath.substring(containerPath.lastIndexOf(47) + 1);
                List<ShortcutDTO> shortcutDTOS = this.libraryManager.fetchShortcuts().stream().flatMap(shortcutCategory -> shortcutCategory.getShortcuts().stream()).filter(shortcut -> {
                    boolean toAdd = false;
                    try {
                        Map shortcutProperties = (Map)this.objectMapper.readValue(shortcut.getScript(), (TypeReference)new TypeReference<Map<String, Object>>(){});
                        toAdd = shortcutProperties.get("winePrefix").equals(containerName);
                    }
                    catch (IOException e) {
                        this.LOGGER.warn("Could not parse shortcut script JSON", (Throwable)e);
                    }
                    return toAdd;
                }).collect(Collectors.toList());
                if (!directory.getName().equals("wineprefix")) continue;
                containers.add(new WinePrefixContainerDTO.Builder().withName(containerDirectory.getName()).withPath(containerPath).withInstalledShortcuts(shortcutDTOS).withArchitecture(configFile.readValue("wineArchitecture", "")).withDistribution(configFile.readValue("wineDistribution", "")).withVersion(configFile.readValue("wineVersion", "")).build());
            }
            containers.sort(ContainerDTO.nameComparator());
        }
        return containers;
    }
}

