/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.containers;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.phoenicis.containers.ContainersManager;
import org.phoenicis.containers.dto.ContainerCategoryDTO;
import org.phoenicis.containers.dto.ContainerDTO;

class BackgroundContainersManager
implements ContainersManager {
    private final ContainersManager delegatedContainersManager;
    private final ExecutorService executorService;

    BackgroundContainersManager(ContainersManager delegatedContainersManager, ExecutorService executorService) {
        this.delegatedContainersManager = delegatedContainersManager;
        this.executorService = executorService;
    }

    @Override
    public void fetchContainers(Consumer<List<ContainerCategoryDTO>> onSuccess, Consumer<Exception> onError) {
        this.executorService.submit(() -> this.delegatedContainersManager.fetchContainers(onSuccess, onError));
    }

    @Override
    public void deleteContainer(ContainerDTO container, Consumer<ContainerDTO> onSuccess, Consumer<Exception> onError) {
        this.executorService.submit(() -> this.delegatedContainersManager.deleteContainer(container, onSuccess, onError));
    }
}

