/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmimemagic.detectors;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.regex.Pattern;
import net.sf.jmimemagic.MagicDetector;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TextFileDetector
implements MagicDetector {
    private static Log log = LogFactory.getLog(TextFileDetector.class);

    @Override
    public String getDisplayName() {
        return "Text File Detector";
    }

    @Override
    public String getVersion() {
        return "0.1";
    }

    @Override
    public String[] getHandledExtensions() {
        return new String[]{"txt", "text"};
    }

    @Override
    public String[] getHandledTypes() {
        return new String[]{"text/plain"};
    }

    @Override
    public String getName() {
        return "textfiledetector";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] process(byte[] data, int offset, int length, long bitmask, char comparator, String mimeType, Map<String, String> params) {
        log.debug((Object)"processing stream data");
        BOMInputStream bomIn = null;
        try {
            bomIn = new BOMInputStream((InputStream)new ByteArrayInputStream(data), new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_16BE});
            if (bomIn.hasBOM()) {
                String[] stringArray = new String[]{"text/plain"};
                IOUtils.closeQuietly((InputStream)bomIn);
                return stringArray;
            }
            IOUtils.closeQuietly((InputStream)bomIn);
        }
        catch (IOException e) {
            log.error((Object)"TextFileDetector: error detecting byte order mark");
        }
        finally {
            IOUtils.closeQuietly(bomIn);
        }
        try {
            String s = new String(data, "UTF-8");
            if (!Pattern.matches("/[^[:ascii:][:space:]]/", s)) {
                return new String[]{"text/plain"};
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"TextFileDetector: failed to process data");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] process(File file, int offset, int length, long bitmask, char comparator, String mimeType, Map<String, String> params) {
        BufferedInputStream is;
        block4: {
            String[] stringArray;
            log.debug((Object)"processing file data");
            is = null;
            try {
                is = new BufferedInputStream(new FileInputStream(file));
                byte[] b = new byte[length];
                int n = is.read(b, offset, length);
                if (n <= 0) break block4;
                stringArray = this.process(b, offset, length, bitmask, comparator, mimeType, params);
            }
            catch (IOException e) {
                try {
                    log.error((Object)"TextFileDetector: error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)is);
            }
            IOUtils.closeQuietly((InputStream)is);
            return stringArray;
        }
        IOUtils.closeQuietly((InputStream)is);
        return null;
    }
}

