/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.repository.types;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.phoenicis.repository.dto.RepositoryDTO;
import org.phoenicis.repository.types.MergeableRepository;
import org.phoenicis.repository.types.Repository;

public class TeeRepository
extends MergeableRepository {
    private final Repository leftRepository;
    private final Repository rightRepository;

    public TeeRepository(Repository leftRepository, Repository rightRepository) {
        this.leftRepository = leftRepository;
        this.rightRepository = rightRepository;
    }

    @Override
    public RepositoryDTO fetchInstallableApplications() {
        Map<Repository, RepositoryDTO> repositoriesMap = Arrays.asList(this.leftRepository, this.rightRepository).stream().collect(Collectors.toMap(source -> source, Repository::fetchInstallableApplications));
        return this.mergeRepositories(repositoriesMap, Arrays.asList(this.leftRepository, this.rightRepository));
    }

    @Override
    public void onDelete() {
        this.leftRepository.onDelete();
        this.rightRepository.onDelete();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TeeRepository that = (TeeRepository)o;
        return new EqualsBuilder().append((Object)this.leftRepository, (Object)that.leftRepository).append((Object)this.rightRepository, (Object)that.rightRepository).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.leftRepository).append((Object)this.rightRepository).toHashCode();
    }
}

