/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.repository.types;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.phoenicis.repository.dto.ApplicationDTO;
import org.phoenicis.repository.dto.CategoryDTO;
import org.phoenicis.repository.dto.RepositoryDTO;
import org.phoenicis.repository.dto.ScriptDTO;
import org.phoenicis.repository.dto.TypeDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Repository {
    public static final Logger LOGGER = LoggerFactory.getLogger(Repository.class);

    public RepositoryDTO fetchInstallableApplications();

    default public boolean isSafe() {
        return false;
    }

    default public void onDelete() {
    }

    default public void fetchInstallableApplications(Consumer<RepositoryDTO> callback, Consumer<Exception> errorCallback) {
        try {
            callback.accept(this.fetchInstallableApplications());
        }
        catch (Exception e) {
            LOGGER.error("Fetching installable applications failed!", (Throwable)e);
            errorCallback.accept(e);
        }
    }

    default public RepositoryDTO getRepository() {
        return this.fetchInstallableApplications();
    }

    default public TypeDTO getType(List<String> path) {
        String wantedId = path.get(0);
        Optional<TypeDTO> typeDTO = this.fetchInstallableApplications().getTypes().stream().filter(type -> wantedId.equals(type.getId())).findFirst();
        if (!typeDTO.isPresent()) {
            LOGGER.error(String.format("Could not find TypeDTO with ID \"%s\"", wantedId));
        }
        return typeDTO.orElse(null);
    }

    default public CategoryDTO getCategory(List<String> path) {
        String wantedId = path.get(1);
        TypeDTO typeDTO = this.getType(path);
        if (typeDTO == null) {
            return null;
        }
        Optional<CategoryDTO> categoryDTO = typeDTO.getCategories().stream().filter(category -> wantedId.equals(category.getId())).findFirst();
        if (!categoryDTO.isPresent()) {
            LOGGER.error(String.format("Could not find CategoryDTO with ID \"%s\"", wantedId));
        }
        return categoryDTO.orElse(null);
    }

    default public ApplicationDTO getApplication(List<String> path) {
        String wantedId = path.get(2);
        CategoryDTO categoryDTO = this.getCategory(path);
        if (categoryDTO == null) {
            return null;
        }
        Optional<ApplicationDTO> applicationDTO = categoryDTO.getApplications().stream().filter(application -> wantedId.equals(application.getId())).findFirst();
        if (!applicationDTO.isPresent()) {
            LOGGER.error(String.format("Could not find ApplicationDTO with ID \"%s\"", wantedId));
        }
        return applicationDTO.orElse(null);
    }

    default public ScriptDTO getScript(List<String> path) {
        String wantedId = path.get(3);
        ApplicationDTO applicationDTO = this.getApplication(path);
        if (applicationDTO != null) {
            for (ScriptDTO scriptDTO : applicationDTO.getScripts()) {
                if (!wantedId.equals(scriptDTO.getId())) continue;
                return scriptDTO;
            }
        }
        LOGGER.error(String.format("Could not find ScriptDTO with ID \"%s\"", wantedId));
        return null;
    }

    default public ScriptDTO getScript(String id) {
        RepositoryDTO repositoryDTO = this.getRepository();
        for (TypeDTO typeDTO : repositoryDTO.getTypes()) {
            for (CategoryDTO categoryDTO : typeDTO.getCategories()) {
                for (ApplicationDTO applicationDTO : categoryDTO.getApplications()) {
                    for (ScriptDTO scriptDTO : applicationDTO.getScripts()) {
                        if (!id.equals(scriptDTO.getId())) continue;
                        return scriptDTO;
                    }
                }
            }
        }
        return null;
    }

    default public void getScript(List<String> path, Consumer<ScriptDTO> callback, Consumer<Exception> errorCallback) {
        callback.accept(this.getScript(path));
    }
}

