/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.repository.types;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.phoenicis.repository.dto.RepositoryDTO;
import org.phoenicis.repository.types.MergeableRepository;
import org.phoenicis.repository.types.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleRepository
extends MergeableRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultipleRepository.class);
    private List<Repository> repositories;

    public MultipleRepository(Repository ... repositories) {
        this.repositories = new ArrayList<Repository>(Arrays.asList(repositories));
    }

    public MultipleRepository(List<Repository> repositories) {
        this.repositories = repositories;
    }

    @Override
    public RepositoryDTO fetchInstallableApplications() {
        LOGGER.info(String.format("Fetching applications for: %s", this.toString()));
        Map repositoriesMap = ((Stream)this.repositories.stream().parallel()).collect(Collectors.toConcurrentMap(source -> source, Repository::fetchInstallableApplications));
        return this.mergeRepositories(repositoriesMap, this.repositories);
    }

    @Override
    public void onDelete() {
        this.repositories.stream().forEach(Repository::onDelete);
    }

    public int size() {
        return this.repositories.size();
    }

    public void moveRepository(Repository repository, int toIndex) {
        int oldIndex = this.repositories.indexOf(repository);
        Collections.swap(this.repositories, oldIndex, toIndex);
    }

    public void addRepository(Repository repository) {
        this.repositories.add(repository);
    }

    public void addRepository(int index, Repository repository) {
        this.repositories.add(index, repository);
    }

    public void removeRepository(Repository repository) {
        this.repositories.remove(repository);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("repositories", this.repositories).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultipleRepository that = (MultipleRepository)o;
        return new EqualsBuilder().append(this.repositories, that.repositories).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.repositories).toHashCode();
    }
}

