/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.repository.types;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.function.Function;
import org.apache.commons.codec.digest.DigestUtils;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.configuration.localisation.PropertiesResourceBundle;
import org.phoenicis.repository.dto.ApplicationDTO;
import org.phoenicis.repository.dto.CategoryDTO;
import org.phoenicis.repository.dto.RepositoryDTO;
import org.phoenicis.repository.dto.ResourceDTO;
import org.phoenicis.repository.dto.ScriptDTO;
import org.phoenicis.repository.dto.TranslationDTO;
import org.phoenicis.repository.dto.TypeDTO;
import org.phoenicis.repository.types.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class MergeableRepository
implements Repository {
    private static final Logger LOGGER = LoggerFactory.getLogger(MergeableRepository.class);

    MergeableRepository() {
    }

    protected RepositoryDTO mergeRepositories(Map<Repository, RepositoryDTO> repositoriesMap, List<Repository> repositories) {
        int numberOfRepositories = repositories.size();
        if (numberOfRepositories == 0) {
            return null;
        }
        RepositoryDTO.Builder repositoryDTOBuilder = new RepositoryDTO.Builder().withName("merged repository");
        Properties translationProperties = new Properties();
        HashMap<Repository, List<TypeDTO>> typesMap = new HashMap<Repository, List<TypeDTO>>();
        for (Map.Entry<Repository, RepositoryDTO> entry : repositoriesMap.entrySet()) {
            RepositoryDTO repositoryDTO = entry.getValue();
            translationProperties.putAll((Map<?, ?>)repositoryDTO.getTranslations().getProperties());
            typesMap.put(entry.getKey(), repositoryDTO.getTypes());
        }
        repositoryDTOBuilder.withTranslations(new TranslationDTO.Builder().withLanguage(Locale.getDefault().getLanguage()).withProperties(translationProperties).build());
        Localisation.setAdditionalTranslations((PropertiesResourceBundle)new PropertiesResourceBundle(translationProperties));
        Map<String, TypeDTO> mergedTypes = this.createSortedMap((List)typesMap.get(repositories.get(numberOfRepositories - 1)), TypeDTO::getId);
        for (int otherRepositoryIndex = numberOfRepositories - 2; otherRepositoryIndex >= 0; --otherRepositoryIndex) {
            List otherTypes = (List)typesMap.get(repositories.get(otherRepositoryIndex));
            Map<String, TypeDTO> otherTypesMap = this.createSortedMap(otherTypes, TypeDTO::getId);
            for (Map.Entry<String, TypeDTO> entry : otherTypesMap.entrySet()) {
                TypeDTO type = entry.getValue();
                if (mergedTypes.containsKey(entry.getKey())) {
                    mergedTypes.put(entry.getKey(), this.mergeTypes(mergedTypes.get(entry.getKey()), type));
                    continue;
                }
                mergedTypes.put(entry.getKey(), type);
            }
        }
        RepositoryDTO mergedRepositoryDTO = repositoryDTOBuilder.withTypes(new ArrayList<TypeDTO>(mergedTypes.values())).build();
        return mergedRepositoryDTO;
    }

    protected TypeDTO mergeTypes(TypeDTO leftCategory, TypeDTO rightCategory) {
        Map<String, CategoryDTO> leftCategories = this.createSortedMap(leftCategory.getCategories(), CategoryDTO::getId);
        Map<String, CategoryDTO> rightCategories = this.createSortedMap(rightCategory.getCategories(), CategoryDTO::getId);
        TreeMap<String, CategoryDTO> mergedCategories = new TreeMap<String, CategoryDTO>(rightCategories);
        for (Map.Entry<String, CategoryDTO> entry : leftCategories.entrySet()) {
            CategoryDTO category = entry.getValue();
            if (mergedCategories.containsKey(entry.getKey())) {
                mergedCategories.put(entry.getKey(), this.mergeCategories((CategoryDTO)mergedCategories.get(entry.getKey()), category));
                continue;
            }
            mergedCategories.put(entry.getKey(), category);
        }
        ArrayList<CategoryDTO> categories = new ArrayList<CategoryDTO>(mergedCategories.values());
        categories.sort(CategoryDTO.nameComparator());
        return new TypeDTO.Builder().withId(leftCategory.getId()).withName(leftCategory.getName()).withCategories(categories).withIcon(leftCategory.getIcon()).build();
    }

    protected CategoryDTO mergeCategories(CategoryDTO leftCategory, CategoryDTO rightCategory) {
        Map<String, ApplicationDTO> leftApplications = this.createSortedMap(leftCategory.getApplications(), ApplicationDTO::getId);
        Map<String, ApplicationDTO> rightApplications = this.createSortedMap(rightCategory.getApplications(), ApplicationDTO::getId);
        TreeMap<String, ApplicationDTO> mergedApps = new TreeMap<String, ApplicationDTO>(rightApplications);
        for (Map.Entry<String, ApplicationDTO> entry : leftApplications.entrySet()) {
            ApplicationDTO application = entry.getValue();
            if (mergedApps.containsKey(entry.getKey())) {
                mergedApps.put(entry.getKey(), this.mergeApplications((ApplicationDTO)mergedApps.get(entry.getKey()), application));
                continue;
            }
            mergedApps.put(entry.getKey(), application);
        }
        ArrayList<ApplicationDTO> applications = new ArrayList<ApplicationDTO>(mergedApps.values());
        applications.sort(ApplicationDTO.nameComparator());
        return new CategoryDTO.Builder().withTypeId(leftCategory.getTypeId()).withId(leftCategory.getId()).withName(leftCategory.getName()).withApplications(applications).withType(leftCategory.getType()).withIcon(leftCategory.getIcon()).build();
    }

    protected ApplicationDTO mergeApplications(ApplicationDTO leftApplication, ApplicationDTO rightApplication) {
        List<ScriptDTO> scripts = this.mergeListOfDtos(leftApplication.getScripts(), rightApplication.getScripts(), ScriptDTO::getScriptName, ScriptDTO.nameComparator());
        List<ResourceDTO> resources = this.mergeListOfDtos(leftApplication.getResources(), rightApplication.getResources(), ResourceDTO::getName, ResourceDTO.nameComparator());
        List<URI> mergeMiniatures = this.mergeMiniatures(leftApplication.getMiniatures(), rightApplication.getMiniatures());
        return new ApplicationDTO.Builder().withCategoryId(leftApplication.getCategoryId()).withId(leftApplication.getId()).withName(leftApplication.getName()).withResources(resources).withScripts(scripts).withDescription(leftApplication.getDescription()).withIcon(leftApplication.getIcon()).withMiniatures(mergeMiniatures).build();
    }

    protected List<URI> mergeMiniatures(List<URI> leftMiniatures, List<URI> rightMiniatures) {
        HashMap<String, URI> mergedMiniatures = new HashMap<String, URI>();
        ArrayList<URI> miniatures = new ArrayList<URI>(leftMiniatures);
        miniatures.addAll(rightMiniatures);
        for (URI miniatureUri : miniatures) {
            try {
                InputStream inputStream = miniatureUri.toURL().openStream();
                try {
                    String checksum = DigestUtils.md5Hex((InputStream)inputStream);
                    if (mergedMiniatures.containsKey(checksum)) continue;
                    mergedMiniatures.put(checksum, miniatureUri);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException e) {
                LOGGER.error(String.format("Couldn't merge miniatures at %s", miniatureUri.toString()), (Throwable)e);
            }
        }
        return new ArrayList<URI>(mergedMiniatures.values());
    }

    protected <T> List<T> mergeListOfDtos(List<T> leftList, List<T> rightList, Function<T, String> nameSupplier, Comparator<T> sorter) {
        Map<String, T> left = this.createSortedMap(leftList, nameSupplier);
        Map<String, T> right = this.createSortedMap(rightList, nameSupplier);
        TreeMap<String, T> merged = new TreeMap<String, T>(left);
        for (Map.Entry<String, T> entry : right.entrySet()) {
            T dto = entry.getValue();
            if (merged.containsKey(entry.getKey())) continue;
            merged.put(entry.getKey(), dto);
        }
        ArrayList result = new ArrayList(merged.values());
        result.sort(sorter);
        return result;
    }

    protected <T> Map<String, T> createSortedMap(List<T> dtos, Function<T, String> nameProvider) {
        TreeMap map = new TreeMap();
        dtos.forEach(dto -> map.put((String)nameProvider.apply(dto), dto));
        return map;
    }
}

