/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.repository.types;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.configuration.localisation.PropertiesResourceBundle;
import org.phoenicis.repository.RepositoryException;
import org.phoenicis.repository.dto.ApplicationDTO;
import org.phoenicis.repository.dto.CategoryDTO;
import org.phoenicis.repository.dto.RepositoryDTO;
import org.phoenicis.repository.dto.ResourceDTO;
import org.phoenicis.repository.dto.ScriptDTO;
import org.phoenicis.repository.dto.TranslationDTO;
import org.phoenicis.repository.dto.TypeDTO;
import org.phoenicis.repository.types.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalRepository
implements Repository {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalRepository.class);
    private static final String ICON_NAME = "icon.png";
    private final File repositoryDirectory;
    private final ObjectMapper objectMapper;
    private final URI repositorySource;
    private static final String INVALID_ID_CHARS_REGEX = "[^a-zA-Z0-9_.]";

    private LocalRepository(File repositoryDirectory, URI repositorySource, ObjectMapper objectMapper) {
        this.repositoryDirectory = repositoryDirectory;
        this.objectMapper = objectMapper;
        this.repositorySource = repositorySource;
    }

    private LocalRepository(File repositoryDirectory, ObjectMapper objectMapper) {
        this(repositoryDirectory, repositoryDirectory.toURI(), objectMapper);
    }

    @Override
    public RepositoryDTO fetchInstallableApplications() {
        if (!this.repositoryDirectory.exists()) {
            throw new RepositoryException(String.format("Repository %s directory does not exist.", this.repositoryDirectory));
        }
        File[] typeDirectories = this.repositoryDirectory.listFiles();
        if (typeDirectories == null) {
            return new RepositoryDTO.Builder().build();
        }
        LOGGER.info("Reading directory : " + this.repositoryDirectory);
        RepositoryDTO.Builder repositoryDTOBuilder = new RepositoryDTO.Builder().withName(this.repositoryDirectory.getName()).withTypes(this.fetchTypes(typeDirectories));
        File i18nDirectory = new File(this.repositoryDirectory, "i18n");
        if (i18nDirectory.exists()) {
            File[] translationFiles = i18nDirectory.listFiles((dir, name) -> name.endsWith(Locale.getDefault().getLanguage() + ".properties"));
            Properties mergedProperties = new Properties();
            for (File translationFile : translationFiles) {
                try {
                    Properties langProperties = new Properties();
                    langProperties.load(new FileInputStream(translationFile));
                    mergedProperties.putAll((Map<?, ?>)langProperties);
                }
                catch (IOException e) {
                    LOGGER.error("Could not read translation properties", (Throwable)e);
                }
            }
            repositoryDTOBuilder.withTranslations(new TranslationDTO.Builder().withLanguage(Locale.getDefault().getLanguage()).withProperties(mergedProperties).build());
            Localisation.setAdditionalTranslations((PropertiesResourceBundle)new PropertiesResourceBundle(mergedProperties));
        }
        return repositoryDTOBuilder.build();
    }

    private List<TypeDTO> fetchTypes(File[] typeDirectories) {
        ArrayList<TypeDTO> results = new ArrayList<TypeDTO>();
        for (File typeDirectory : typeDirectories) {
            File typeIconFile;
            File typeJson;
            if (!typeDirectory.isDirectory() || typeDirectory.getName().startsWith(".") || !(typeJson = new File(typeDirectory, "type.json")).exists()) continue;
            TypeDTO jsonTypeDTO = this.unSerializeType(typeJson);
            TypeDTO.Builder typeDTOBuilder = new TypeDTO.Builder(jsonTypeDTO);
            if (StringUtils.isBlank((String)jsonTypeDTO.getId())) {
                if (!StringUtils.isBlank((String)jsonTypeDTO.getName())) {
                    typeDTOBuilder.withId(jsonTypeDTO.getName().replaceAll(INVALID_ID_CHARS_REGEX, ""));
                } else {
                    typeDTOBuilder.withId(typeDirectory.getName().replaceAll(INVALID_ID_CHARS_REGEX, ""));
                }
            }
            if ((typeIconFile = new File(typeDirectory, ICON_NAME)).exists()) {
                typeDTOBuilder.withIcon(typeIconFile.toURI());
            }
            typeDTOBuilder.withCategories(this.fetchCategories(typeDTOBuilder.getId(), typeDirectory));
            TypeDTO type = typeDTOBuilder.build();
            results.add(type);
        }
        results.sort(Comparator.comparing(TypeDTO::getName));
        return results;
    }

    private List<CategoryDTO> fetchCategories(String typeId, File typeDirectory) {
        File[] categoryDirectories = typeDirectory.listFiles();
        if (categoryDirectories == null) {
            return Collections.emptyList();
        }
        ArrayList<CategoryDTO> results = new ArrayList<CategoryDTO>();
        for (File categoryDirectory : categoryDirectories) {
            File categoryIconFile;
            File categoryJson;
            if (!categoryDirectory.isDirectory() || categoryDirectory.getName().startsWith(".") || !(categoryJson = new File(categoryDirectory, "category.json")).exists()) continue;
            CategoryDTO jsonCategoryDTO = this.unSerializeCategory(categoryJson);
            CategoryDTO.Builder categoryDTOBuilder = new CategoryDTO.Builder(jsonCategoryDTO);
            categoryDTOBuilder.withTypeId(typeId);
            if (StringUtils.isBlank((String)jsonCategoryDTO.getId())) {
                if (!StringUtils.isBlank((String)jsonCategoryDTO.getName())) {
                    categoryDTOBuilder.withId(jsonCategoryDTO.getName().replaceAll(INVALID_ID_CHARS_REGEX, ""));
                } else {
                    categoryDTOBuilder.withId(categoryDirectory.getName().replaceAll(INVALID_ID_CHARS_REGEX, ""));
                }
            }
            if ((categoryIconFile = new File(categoryDirectory, ICON_NAME)).exists()) {
                categoryDTOBuilder.withIcon(categoryIconFile.toURI());
            }
            categoryDTOBuilder.withApplications(this.fetchApplications(categoryDTOBuilder.getTypeId(), categoryDTOBuilder.getId(), categoryDirectory));
            CategoryDTO category = categoryDTOBuilder.build();
            results.add(category);
        }
        results.sort(Comparator.comparing(CategoryDTO::getName));
        return results;
    }

    private List<ApplicationDTO> fetchApplications(String typeId, String categoryId, File categoryDirectory) {
        File[] applicationDirectories = categoryDirectory.listFiles();
        if (applicationDirectories == null) {
            return Collections.emptyList();
        }
        ArrayList<ApplicationDTO> results = new ArrayList<ApplicationDTO>();
        for (File applicationDirectory : applicationDirectories) {
            File miniaturesDirectory;
            if (!applicationDirectory.isDirectory()) continue;
            File applicationJson = new File(applicationDirectory, "application.json");
            ApplicationDTO.Builder applicationDTOBuilder = applicationJson.exists() ? new ApplicationDTO.Builder(this.unSerializeApplication(applicationJson)) : new ApplicationDTO.Builder();
            applicationDTOBuilder.withTypeId(typeId).withCategoryId(categoryId);
            if (StringUtils.isBlank((String)applicationDTOBuilder.getId())) {
                if (!StringUtils.isBlank((String)applicationDTOBuilder.getName())) {
                    applicationDTOBuilder.withId(applicationDTOBuilder.getName().replaceAll(INVALID_ID_CHARS_REGEX, ""));
                } else {
                    applicationDTOBuilder.withId(applicationDirectory.getName().replaceAll(INVALID_ID_CHARS_REGEX, ""));
                }
            }
            if ((miniaturesDirectory = new File(applicationDirectory, "miniatures")).exists() && miniaturesDirectory.isDirectory()) {
                try {
                    applicationDTOBuilder.withMiniatures(this.fetchMiniatures(miniaturesDirectory));
                }
                catch (IOException e) {
                    LOGGER.warn("Unable to read miniatures", (Throwable)e);
                }
            }
            applicationDTOBuilder.withScripts(this.fetchScripts(applicationDTOBuilder.getTypeId(), applicationDTOBuilder.getCategoryId(), applicationDTOBuilder.getId(), applicationDirectory)).withResources(this.fetchResources(applicationDirectory));
            ApplicationDTO app = applicationDTOBuilder.build();
            results.add(app);
        }
        Collections.sort(results, Comparator.comparing(ApplicationDTO::getName));
        return results;
    }

    private List<URI> fetchMiniatures(File miniaturesDirectory) throws IOException {
        File[] miniatureFiles = miniaturesDirectory.listFiles();
        return Arrays.stream(miniatureFiles).filter(miniatureFile -> !miniatureFile.isDirectory() && !miniatureFile.getName().startsWith(".")).map(File::toURI).collect(Collectors.toList());
    }

    private List<ResourceDTO> fetchResources(File applicationDirectory) {
        File[] resources = new File(applicationDirectory, "resources").listFiles();
        if (resources == null) {
            return Collections.emptyList();
        }
        ArrayList<ResourceDTO> results = new ArrayList<ResourceDTO>();
        for (File resourceFile : resources) {
            if (resourceFile.isDirectory() || resourceFile.getName().startsWith(".")) continue;
            try {
                results.add(new ResourceDTO(resourceFile.getName(), IOUtils.toByteArray((InputStream)new FileInputStream(resourceFile))));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return results;
    }

    private List<ScriptDTO> fetchScripts(String typeId, String categoryId, String applicationId, File applicationDirectory) {
        File[] scriptDirectories = applicationDirectory.listFiles();
        if (scriptDirectories == null) {
            return Collections.emptyList();
        }
        ArrayList<ScriptDTO> results = new ArrayList<ScriptDTO>();
        for (File scriptDirectory : scriptDirectories) {
            File iconFile;
            ScriptDTO.Builder scriptDTOBuilder;
            if (!scriptDirectory.isDirectory() || "miniatures".equals(scriptDirectory.getName()) || "resources".equals(scriptDirectory.getName())) continue;
            File scriptJson = new File(scriptDirectory, "script.json");
            if (scriptJson.exists()) {
                ScriptDTO scriptDTOFromJsonFile = this.unSerializeScript(scriptJson);
                scriptDTOBuilder = new ScriptDTO.Builder(scriptDTOFromJsonFile);
                if (StringUtils.isBlank((String)scriptDTOFromJsonFile.getScriptName())) {
                    scriptDTOBuilder.withScriptName(scriptDirectory.getName());
                }
            } else {
                scriptDTOBuilder = new ScriptDTO.Builder();
                scriptDTOBuilder.withScriptName(scriptDirectory.getName());
            }
            if (StringUtils.isBlank((String)scriptDTOBuilder.getId())) {
                if (!StringUtils.isBlank((String)scriptDTOBuilder.getScriptName())) {
                    scriptDTOBuilder.withId(scriptDTOBuilder.getScriptName().replaceAll(INVALID_ID_CHARS_REGEX, ""));
                } else {
                    scriptDTOBuilder.withId(scriptDirectory.getName().replaceAll(INVALID_ID_CHARS_REGEX, ""));
                }
            }
            scriptDTOBuilder.withTypeId(typeId).withCategoryId(categoryId).withApplicationId(applicationId).withScriptSource(this.repositorySource);
            File scriptFile = new File(scriptDirectory, "script.js");
            if (scriptFile.exists()) {
                try {
                    scriptDTOBuilder.withScript(new String(IOUtils.toByteArray((InputStream)new FileInputStream(scriptFile))));
                }
                catch (IOException e) {
                    LOGGER.warn("Script not found", (Throwable)e);
                }
            }
            if ((iconFile = new File(scriptDirectory, ICON_NAME)).exists()) {
                scriptDTOBuilder.withIcon(iconFile.toURI());
            } else {
                LOGGER.debug("Icon not found: " + iconFile.getAbsolutePath());
            }
            results.add(scriptDTOBuilder.build());
        }
        return results;
    }

    private TypeDTO unSerializeType(File jsonFile) {
        try {
            return (TypeDTO)this.objectMapper.readValue(jsonFile, TypeDTO.class);
        }
        catch (IOException e) {
            LOGGER.debug("JSON file not found", (Throwable)e);
            return new TypeDTO.Builder().build();
        }
    }

    private CategoryDTO unSerializeCategory(File jsonFile) {
        try {
            return (CategoryDTO)this.objectMapper.readValue(jsonFile, CategoryDTO.class);
        }
        catch (IOException e) {
            LOGGER.debug("JSON file not found", (Throwable)e);
            return new CategoryDTO.Builder().build();
        }
    }

    private ScriptDTO unSerializeScript(File jsonFile) {
        try {
            return (ScriptDTO)this.objectMapper.readValue(jsonFile, ScriptDTO.class);
        }
        catch (IOException e) {
            LOGGER.debug("JSON file not found");
            return new ScriptDTO.Builder().build();
        }
    }

    private ApplicationDTO unSerializeApplication(File jsonFile) {
        try {
            return (ApplicationDTO)this.objectMapper.readValue(jsonFile, ApplicationDTO.class);
        }
        catch (IOException e) {
            LOGGER.debug("JSON file not found", (Throwable)e);
            return new ApplicationDTO.Builder().build();
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("repositorySource", (Object)this.repositorySource).append("repositoryDirectory", (Object)this.repositoryDirectory).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalRepository that = (LocalRepository)o;
        return new EqualsBuilder().append((Object)this.repositoryDirectory, (Object)that.repositoryDirectory).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.repositoryDirectory).toHashCode();
    }

    public static class Factory {
        private final ObjectMapper objectMapper;

        public Factory(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
        }

        public LocalRepository createInstance(File path) {
            return new LocalRepository(path, this.objectMapper);
        }

        public LocalRepository createInstance(File path, URI source) {
            return new LocalRepository(path, source, this.objectMapper);
        }
    }
}

