/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.repository.types;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.FileLock;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.phoenicis.repository.RepositoryException;
import org.phoenicis.repository.dto.RepositoryDTO;
import org.phoenicis.repository.types.LocalRepository;
import org.phoenicis.repository.types.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitRepository
implements Repository {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitRepository.class);
    private final URI repositoryUri;
    private final String branch;
    private final LocalRepository.Factory localRepositoryFactory;
    private final File localFolder;
    private final File lockFile;
    private static final Object mutex = new Object();

    public GitRepository(URI repositoryUri, String branch, String cacheDirectoryPath, LocalRepository.Factory localRepositoryFactory) {
        this.repositoryUri = repositoryUri;
        this.branch = branch == null ? "master" : branch;
        this.localRepositoryFactory = localRepositoryFactory;
        this.localFolder = this.createRepositoryLocation(cacheDirectoryPath);
        this.lockFile = new File(this.localFolder.getAbsolutePath() + ".lock");
    }

    private File createRepositoryLocation(String cacheDirectoryPath) {
        int hashcode = new HashCodeBuilder().append((Object)this.repositoryUri).append((Object)this.branch).toHashCode();
        return new File(cacheDirectoryPath + "/git" + hashcode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cloneOrUpdateWithLock() throws RepositoryException {
        Object object = mutex;
        synchronized (object) {
            try {
                LOGGER.info("Begin fetching process of '{}' to '{}'", (Object)this.repositoryUri, (Object)this.localFolder.getAbsolutePath());
                boolean lockFileExists = this.lockFile.exists();
                if (!lockFileExists) {
                    LOGGER.info("Creating lock file '{}' for git-repository '{}'", (Object)this.lockFile.getAbsolutePath(), (Object)this.repositoryUri);
                    try {
                        this.lockFile.getParentFile().mkdirs();
                        this.lockFile.createNewFile();
                    }
                    catch (IOException e) {
                        String message = String.format("Couldn't create lock file '%s'", this.lockFile.getAbsolutePath());
                        throw new RepositoryException(message, e);
                    }
                }
                try (FileOutputStream lockFileStream = new FileOutputStream(this.lockFile, true);
                     FileLock ignored = lockFileStream.getChannel().lock();){
                    this.cloneOrUpdate();
                }
            }
            catch (IOException e) {
                throw new RepositoryException("An unknown error occurred", e);
            }
        }
    }

    private void cloneOrUpdate() throws RepositoryException {
        block19: {
            boolean folderExists = this.localFolder.exists();
            if (!folderExists) {
                LOGGER.info("Creating local folder '{}' for git-repository '{}'", (Object)this.localFolder.getAbsolutePath(), (Object)this.repositoryUri);
                if (!this.localFolder.mkdirs()) {
                    String message = String.format("Couldn't create local folder '%s' for git-repository '%s'", this.localFolder.getAbsolutePath(), this.repositoryUri);
                    throw new RepositoryException(message);
                }
            }
            if (!folderExists) {
                LOGGER.info("Cloning git-repository '{}' to '{}'", (Object)this.repositoryUri, (Object)this.localFolder.getAbsolutePath());
                try (Git gitRepository = Git.cloneRepository().setURI(this.repositoryUri.toString()).setDirectory(this.localFolder).setBranch(this.branch).call();){
                    LOGGER.info("Finished cloning git-repository '{}' to '{}'", (Object)this.repositoryUri, (Object)this.localFolder);
                    break block19;
                }
                catch (GitAPIException e) {
                    String message = String.format("Folder '%s' is no git-repository", this.localFolder.getAbsolutePath());
                    throw new RepositoryException(message, e);
                }
            }
            LOGGER.info("Opening git-repository at '{}'", (Object)this.localFolder.getAbsolutePath());
            try (Git gitRepository = Git.open((File)this.localFolder);){
                LOGGER.info("Pulling new commits to '{}'", (Object)this.localFolder.getAbsolutePath());
                gitRepository.pull().call();
                LOGGER.info("Finished pulling new commits to '{}'", (Object)this.localFolder.getAbsolutePath());
            }
            catch (IOException | GitAPIException e) {
                LOGGER.warn("Could not update {0}. Local checkout will be used.", e);
            }
        }
    }

    @Override
    public RepositoryDTO fetchInstallableApplications() {
        try {
            this.cloneOrUpdateWithLock();
            RepositoryDTO result = this.localRepositoryFactory.createInstance(this.localFolder, this.repositoryUri).fetchInstallableApplications();
            return result;
        }
        catch (RepositoryException e) {
            String message = String.format("Could not fetch installable applications for git-repository %s", this.toString());
            throw new RepositoryException(message, e);
        }
    }

    @Override
    public void onDelete() {
        try {
            FileUtils.deleteDirectory((File)this.localFolder);
            LOGGER.info("Deleted local folder '{}' for git-repository '{}'", (Object)this.localFolder.getAbsolutePath(), (Object)this.repositoryUri);
        }
        catch (IOException e) {
            String message = String.format("Couldn't delete local folder '%s' for git-repository '%s'", this.localFolder.getAbsolutePath(), this.repositoryUri);
            LOGGER.error(message, (Throwable)e);
        }
    }

    public String toString() {
        return String.format("GitRepository(url: '%s', folder: '%s', branch: '%s')", this.repositoryUri, this.localFolder.getAbsolutePath(), this.branch);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GitRepository that = (GitRepository)o;
        return new EqualsBuilder().append((Object)this.repositoryUri, (Object)that.repositoryUri).append((Object)this.localFolder, (Object)that.localFolder).append((Object)this.branch, (Object)that.branch).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.repositoryUri).append((Object)this.localFolder).append((Object)this.branch).toHashCode();
    }
}

