/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.repository.types;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.phoenicis.repository.dto.RepositoryDTO;
import org.phoenicis.repository.types.Repository;

public class CachedRepository
implements Repository {
    private final Repository repository;
    private RepositoryDTO cache;

    public CachedRepository(Repository repository) {
        this.repository = repository;
    }

    @Override
    public synchronized RepositoryDTO fetchInstallableApplications() {
        if (this.cache == null) {
            this.cache = this.repository.fetchInstallableApplications();
        }
        return this.cache;
    }

    @Override
    public boolean isSafe() {
        return this.repository.isSafe();
    }

    @Override
    public void onDelete() {
        this.repository.onDelete();
    }

    public void clearCache() {
        this.cache = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CachedRepository that = (CachedRepository)o;
        return new EqualsBuilder().append((Object)this.repository, (Object)that.repository).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.repository).toHashCode();
    }
}

