/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.repository.types;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.phoenicis.repository.dto.RepositoryDTO;
import org.phoenicis.repository.dto.ScriptDTO;
import org.phoenicis.repository.types.Repository;

public class BackgroundRepository
implements Repository {
    private final Repository delegatedRepository;
    private final ExecutorService executorService;

    public BackgroundRepository(Repository delegatedRepository, ExecutorService executorService) {
        this.delegatedRepository = delegatedRepository;
        this.executorService = executorService;
    }

    @Override
    public RepositoryDTO fetchInstallableApplications() {
        throw new UnsupportedOperationException("The background apps manager is asynchronous");
    }

    @Override
    public void onDelete() {
        this.delegatedRepository.onDelete();
    }

    @Override
    public void fetchInstallableApplications(Consumer<RepositoryDTO> callback, Consumer<Exception> errorCallback) {
        this.executorService.submit(() -> this.delegatedRepository.fetchInstallableApplications(callback, errorCallback));
    }

    @Override
    public void getScript(List<String> path, Consumer<ScriptDTO> callback, Consumer<Exception> errorCallback) {
        this.executorService.submit(() -> this.delegatedRepository.getScript(path, callback, errorCallback));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackgroundRepository that = (BackgroundRepository)o;
        return new EqualsBuilder().append((Object)this.delegatedRepository, (Object)that.delegatedRepository).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.delegatedRepository).toHashCode();
    }

    public static class Factory {
        public BackgroundRepository createInstance(Repository delegatedRepository, ExecutorService executorService) {
            return new BackgroundRepository(delegatedRepository, executorService);
        }
    }
}

