/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.repository.location;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.File;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.phoenicis.repository.location.RepositoryLocation;
import org.phoenicis.repository.types.ClasspathRepository;
import org.phoenicis.repository.types.LocalRepository;

@JsonDeserialize
public class LocalRepositoryLocation
extends RepositoryLocation<LocalRepository> {
    private final File repositoryLocation;

    @JsonCreator
    public LocalRepositoryLocation(@JsonProperty(value="repositoryLocation") File repositoryLocation) {
        super("local");
        this.repositoryLocation = repositoryLocation;
    }

    @Override
    public LocalRepository createRepository(String cacheDirectoryPath, LocalRepository.Factory localRepositoryFactory, ClasspathRepository.Factory classPathRepositoryFactory) {
        return localRepositoryFactory.createInstance(this.repositoryLocation);
    }

    public File getRepositoryLocation() {
        return this.repositoryLocation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalRepositoryLocation that = (LocalRepositoryLocation)o;
        return new EqualsBuilder().append((Object)this.repositoryLocation, (Object)that.repositoryLocation).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.repositoryLocation).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.repositoryLocation).toString();
    }

    @Override
    public String toDisplayString() {
        return String.format("file:%s", this.repositoryLocation.toString());
    }
}

