/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.repository.location;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.net.URI;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.phoenicis.repository.location.RepositoryLocation;
import org.phoenicis.repository.types.ClasspathRepository;
import org.phoenicis.repository.types.GitRepository;
import org.phoenicis.repository.types.LocalRepository;

@JsonDeserialize(builder=Builder.class)
public class GitRepositoryLocation
extends RepositoryLocation<GitRepository> {
    private final URI gitRepositoryUri;
    private final String branch;

    public GitRepositoryLocation(Builder builder) {
        super("git");
        this.gitRepositoryUri = builder.gitRepositoryUri;
        this.branch = builder.branch;
    }

    @Override
    public GitRepository createRepository(String cacheDirectoryPath, LocalRepository.Factory localRepositoryFactory, ClasspathRepository.Factory classPathRepositoryFactory) {
        return new GitRepository(this.gitRepositoryUri, this.branch, cacheDirectoryPath, localRepositoryFactory);
    }

    public URI getGitRepositoryUri() {
        return this.gitRepositoryUri;
    }

    public String getBranch() {
        return this.branch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GitRepositoryLocation that = (GitRepositoryLocation)o;
        return new EqualsBuilder().append((Object)this.gitRepositoryUri, (Object)that.gitRepositoryUri).append((Object)this.branch, (Object)that.branch).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.gitRepositoryUri).append((Object)this.branch).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.gitRepositoryUri).append((Object)this.branch).toString();
    }

    @Override
    public String toDisplayString() {
        return String.format("git+%s:%s", this.gitRepositoryUri.toString(), this.branch);
    }

    @JsonPOJOBuilder(buildMethodName="build", withPrefix="with")
    public static class Builder {
        private URI gitRepositoryUri;
        private String branch;

        public Builder() {
        }

        public Builder(GitRepositoryLocation location) {
            this.withGitRepositoryUri(location.getGitRepositoryUri());
            this.withBranch(location.getBranch());
        }

        public Builder withGitRepositoryUri(URI gitRepositoryUri) {
            this.gitRepositoryUri = gitRepositoryUri;
            return this;
        }

        public Builder withBranch(String branch) {
            this.branch = branch;
            return this;
        }

        public GitRepositoryLocation build() {
            return new GitRepositoryLocation(this);
        }
    }
}

