/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.repository.location;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.phoenicis.repository.location.RepositoryLocation;
import org.phoenicis.repository.types.ClasspathRepository;
import org.phoenicis.repository.types.LocalRepository;

@JsonDeserialize
public class ClasspathRepositoryLocation
extends RepositoryLocation<ClasspathRepository> {
    private final String packagePath;

    @JsonCreator
    public ClasspathRepositoryLocation(@JsonProperty(value="packagePath") String packagePath) {
        super("classpath");
        this.packagePath = packagePath;
    }

    @Override
    public ClasspathRepository createRepository(String cacheDirectoryPath, LocalRepository.Factory localRepositoryFactory, ClasspathRepository.Factory classPathRepositoryFactory) {
        return classPathRepositoryFactory.createInstance(this.packagePath);
    }

    public String getPackagePath() {
        return this.packagePath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClasspathRepositoryLocation that = (ClasspathRepositoryLocation)o;
        return new EqualsBuilder().append((Object)this.packagePath, (Object)that.packagePath).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.packagePath).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.packagePath).toString();
    }

    @Override
    public String toDisplayString() {
        return String.format("classpath://%s", this.packagePath);
    }
}

