/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.repository.dto;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.phoenicis.configuration.localisation.Translatable;
import org.phoenicis.configuration.localisation.TranslatableBuilder;
import org.phoenicis.configuration.localisation.Translate;
import org.phoenicis.repository.dto.CategoryDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@Translatable
public class TypeDTO {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeDTO.class);
    private final String id;
    private final String name;
    private final List<CategoryDTO> categories;
    private final URI icon;
    private static final String ID_REGEX = "^[a-zA-Z0-9_.]+$";
    private static final String INVALID_ID_CHARS_REGEX = "[^a-zA-Z0-9_.]";

    private TypeDTO(Builder builder) {
        if (builder.id != null) {
            if (builder.id.matches(ID_REGEX)) {
                this.id = builder.id;
            } else {
                LOGGER.warn(String.format("Type ID (%s) contains invalid characters, will remove them.", builder.id));
                this.id = builder.id.replaceAll(INVALID_ID_CHARS_REGEX, "");
            }
        } else {
            this.id = null;
        }
        this.name = builder.name == null ? builder.id : builder.name;
        this.categories = Collections.unmodifiableList(builder.categories);
        this.icon = builder.icon;
    }

    public URI getIcon() {
        return this.icon;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeDTO that = (TypeDTO)o;
        return new EqualsBuilder().append((Object)this.id, (Object)that.id).append((Object)this.name, (Object)that.name).append(this.categories, that.categories).append((Object)this.icon, (Object)that.icon).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.id).append((Object)this.name).append(this.categories).append((Object)this.icon).toHashCode();
    }

    public String getId() {
        return this.id;
    }

    @Translate
    public String getName() {
        return this.name;
    }

    @Translate
    public List<CategoryDTO> getCategories() {
        return this.categories;
    }

    public static Comparator<TypeDTO> nameComparator() {
        return (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName());
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.name).toString();
    }

    @JsonPOJOBuilder(buildMethodName="build", withPrefix="with")
    @TranslatableBuilder
    public static class Builder {
        private String id;
        private String name;
        private List<CategoryDTO> categories = new ArrayList<CategoryDTO>();
        private URI icon;

        public Builder() {
        }

        public Builder(TypeDTO categoryDTO) {
            this.withId(categoryDTO.getId()).withName(categoryDTO.getName()).withCategories(categoryDTO.getCategories()).withIcon(categoryDTO.getIcon());
        }

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withCategories(List<CategoryDTO> categories) {
            this.categories = categories;
            return this;
        }

        public Builder withIcon(URI iconPath) {
            this.icon = iconPath;
            return this;
        }

        public TypeDTO build() {
            return new TypeDTO(this);
        }

        public String getId() {
            return this.id;
        }
    }

    public static enum CategoryType {
        INSTALLERS,
        FUNCTIONS;

    }
}

