/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.repository.dto;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Comparator;
import java.util.Properties;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonDeserialize(builder=Builder.class)
public class TranslationDTO {
    private final String language;
    private final Properties properties;

    private TranslationDTO(Builder builder) {
        this.language = builder.language;
        this.properties = builder.properties;
    }

    public String getLanguage() {
        return this.language;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TranslationDTO that = (TranslationDTO)o;
        return new EqualsBuilder().append((Object)this.language, (Object)that.language).append((Object)this.properties, (Object)that.properties).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.language).append((Object)this.properties).toHashCode();
    }

    public static Comparator<TranslationDTO> nameComparator() {
        return (o1, o2) -> o1.getLanguage().compareToIgnoreCase(o2.getLanguage());
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.language).toString();
    }

    @JsonPOJOBuilder(buildMethodName="build", withPrefix="with")
    public static class Builder {
        private String language;
        private Properties properties = new Properties();

        public Builder() {
        }

        public Builder(TranslationDTO repositoryDTO) {
            this.withLanguage(repositoryDTO.getLanguage()).withProperties(repositoryDTO.getProperties());
        }

        public Builder withLanguage(String language) {
            this.language = language;
            return this;
        }

        public Builder withProperties(Properties properties) {
            this.properties = properties;
            return this;
        }

        public TranslationDTO build() {
            return new TranslationDTO(this);
        }
    }
}

