/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.repository.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.net.URI;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.phoenicis.configuration.localisation.Translatable;
import org.phoenicis.configuration.localisation.TranslatableBuilder;
import org.phoenicis.configuration.localisation.Translate;
import org.phoenicis.entities.OperatingSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=Builder.class)
@Translatable
public class ScriptDTO {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptDTO.class);
    private final String typeId;
    private final String categoryId;
    private final String applicationId;
    private final String id;
    private final String scriptName;
    private final URI scriptSource;
    private final List<OperatingSystem> compatibleOperatingSystems;
    private final List<OperatingSystem> testingOperatingSystems;
    private final Boolean free;
    private final Boolean requiresPatch;
    private final String script;
    private final URI icon;
    private static final String ID_REGEX = "^[a-zA-Z0-9_.]+$";
    private static final String INVALID_ID_CHARS_REGEX = "[^a-zA-Z0-9_.]";

    private ScriptDTO(Builder builder) {
        this.typeId = builder.typeId;
        this.categoryId = builder.categoryId;
        this.applicationId = builder.applicationId;
        if (builder.id != null) {
            if (builder.id.matches(ID_REGEX)) {
                this.id = builder.id;
            } else {
                LOGGER.warn(String.format("Script ID (%s) contains invalid characters, will remove them.", builder.id));
                this.id = builder.id.replaceAll(INVALID_ID_CHARS_REGEX, "");
            }
        } else {
            this.id = null;
        }
        this.scriptName = builder.scriptName == null ? builder.id : builder.scriptName;
        this.scriptSource = builder.scriptSource;
        this.compatibleOperatingSystems = builder.compatibleOperatingSystems;
        this.testingOperatingSystems = builder.testingOperatingSystems;
        this.free = builder.free;
        this.requiresPatch = builder.requiresPatch;
        this.script = builder.script;
        this.icon = builder.icon;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getId() {
        return this.id;
    }

    @Translate
    public String getScriptName() {
        return this.scriptName;
    }

    public URI getScriptSource() {
        return this.scriptSource;
    }

    public List<OperatingSystem> getCompatibleOperatingSystems() {
        return this.compatibleOperatingSystems;
    }

    public Boolean isFree() {
        return this.free;
    }

    public Boolean isRequiresPatch() {
        return this.requiresPatch;
    }

    public List<OperatingSystem> getTestingOperatingSystems() {
        return this.testingOperatingSystems;
    }

    public String getScript() {
        return this.script;
    }

    public URI getIcon() {
        return this.icon;
    }

    public static Comparator<ScriptDTO> nameComparator() {
        return (o1, o2) -> o1.getScriptName().compareToIgnoreCase(o2.getScriptName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptDTO scriptDTO = (ScriptDTO)o;
        return new EqualsBuilder().append((Object)this.typeId, (Object)scriptDTO.typeId).append((Object)this.categoryId, (Object)scriptDTO.categoryId).append((Object)this.applicationId, (Object)scriptDTO.applicationId).append((Object)this.id, (Object)scriptDTO.id).append((Object)this.scriptName, (Object)scriptDTO.scriptName).append((Object)this.scriptSource, (Object)scriptDTO.scriptSource).append(this.compatibleOperatingSystems, scriptDTO.compatibleOperatingSystems).append(this.testingOperatingSystems, scriptDTO.testingOperatingSystems).append((Object)this.free, (Object)scriptDTO.free).append((Object)this.requiresPatch, (Object)scriptDTO.requiresPatch).append((Object)this.script, (Object)scriptDTO.script).append((Object)this.icon, (Object)scriptDTO.icon).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.typeId).append((Object)this.categoryId).append((Object)this.applicationId).append((Object)this.id).append((Object)this.scriptName).append((Object)this.scriptSource).append(this.compatibleOperatingSystems).append(this.testingOperatingSystems).append((Object)this.free).append((Object)this.requiresPatch).append((Object)this.script).append((Object)this.icon).toHashCode();
    }

    @JsonPOJOBuilder(buildMethodName="build", withPrefix="with")
    @TranslatableBuilder
    public static class Builder {
        private String typeId;
        private String categoryId;
        private String applicationId;
        private String id;
        private String scriptName;
        private URI scriptSource;
        private List<OperatingSystem> compatibleOperatingSystems;
        private List<OperatingSystem> testingOperatingSystems;
        private Boolean free;
        private Boolean requiresPatch;
        private String script;
        private URI icon;

        public Builder() {
        }

        public Builder(ScriptDTO scriptDTO) {
            this.withTypeId(scriptDTO.getTypeId()).withCategoryId(scriptDTO.getCategoryId()).withApplicationId(scriptDTO.getApplicationId()).withId(scriptDTO.getId()).withScriptName(scriptDTO.getScriptName()).withScript(scriptDTO.getScript()).withCompatibleOperatingSystems(scriptDTO.getCompatibleOperatingSystems()).withTestingOperatingSystems(scriptDTO.getTestingOperatingSystems()).withFree(scriptDTO.isFree()).withRequiresPatch(scriptDTO.requiresPatch).withIcon(scriptDTO.getIcon());
        }

        public Builder withTypeId(String typeId) {
            this.typeId = typeId;
            return this;
        }

        public Builder withCategoryId(String categoryId) {
            this.categoryId = categoryId;
            return this;
        }

        public Builder withApplicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public Builder withScriptName(String name) {
            this.scriptName = name;
            return this;
        }

        public Builder withScript(String script) {
            this.script = script;
            return this;
        }

        public Builder withScriptSource(URI scriptSource) {
            this.scriptSource = scriptSource;
            return this;
        }

        public Builder withCompatibleOperatingSystems(List<OperatingSystem> compatibleOperatingSystems) {
            this.compatibleOperatingSystems = compatibleOperatingSystems;
            return this;
        }

        public Builder withTestingOperatingSystems(List<OperatingSystem> testingOperatingSystems) {
            this.testingOperatingSystems = testingOperatingSystems;
            return this;
        }

        public Builder withFree(Boolean free) {
            this.free = free;
            return this;
        }

        public Builder withRequiresPatch(Boolean requiresPatch) {
            this.requiresPatch = requiresPatch;
            return this;
        }

        public Builder withIcon(URI icon) {
            this.icon = icon;
            return this;
        }

        public ScriptDTO build() {
            return new ScriptDTO(this);
        }

        public String getId() {
            return this.id;
        }

        public String getScriptName() {
            return this.scriptName;
        }
    }
}

