/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.repository.dto;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.phoenicis.configuration.localisation.Translatable;
import org.phoenicis.configuration.localisation.TranslatableBuilder;
import org.phoenicis.configuration.localisation.Translate;
import org.phoenicis.repository.dto.TranslationDTO;
import org.phoenicis.repository.dto.TypeDTO;

@JsonDeserialize(builder=Builder.class)
@Translatable
public class RepositoryDTO {
    private final String name;
    private final List<TypeDTO> types;
    private final TranslationDTO translations;

    private RepositoryDTO(Builder builder) {
        this.name = builder.name;
        this.types = Collections.unmodifiableList(builder.types);
        this.translations = builder.translations;
    }

    public TranslationDTO getTranslations() {
        return this.translations;
    }

    public String getName() {
        return this.name;
    }

    @Translate
    public List<TypeDTO> getTypes() {
        return this.types;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryDTO that = (RepositoryDTO)o;
        return new EqualsBuilder().append((Object)this.name, (Object)that.name).append(this.types, that.types).append((Object)this.translations, (Object)that.translations).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.name).append(this.types).append((Object)this.translations).toHashCode();
    }

    public static Comparator<RepositoryDTO> nameComparator() {
        return (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName());
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.name).toString();
    }

    @JsonPOJOBuilder(buildMethodName="build", withPrefix="with")
    @TranslatableBuilder
    public static class Builder {
        private String name;
        private List<TypeDTO> types = new ArrayList<TypeDTO>();
        private TranslationDTO translations = new TranslationDTO.Builder().build();

        public Builder() {
        }

        public Builder(RepositoryDTO repositoryDTO) {
            this.withName(repositoryDTO.getName()).withTypes(repositoryDTO.getTypes()).withTranslations(repositoryDTO.getTranslations());
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withTypes(List<TypeDTO> types) {
            this.types = types;
            return this;
        }

        public RepositoryDTO build() {
            return new RepositoryDTO(this);
        }

        public Builder withTranslations(TranslationDTO translations) {
            this.translations = translations;
            return this;
        }
    }
}

