/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.repository.dto;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.phoenicis.configuration.localisation.Translatable;
import org.phoenicis.configuration.localisation.TranslatableBuilder;
import org.phoenicis.configuration.localisation.Translate;
import org.phoenicis.repository.dto.ApplicationDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@Translatable
public class CategoryDTO {
    private static final Logger LOGGER = LoggerFactory.getLogger(CategoryDTO.class);
    private final String typeId;
    private final CategoryType type;
    private final String id;
    private final String name;
    private final List<ApplicationDTO> applications;
    private final URI icon;
    private static final String ID_REGEX = "^[a-zA-Z0-9_.]+$";
    private static final String INVALID_ID_CHARS_REGEX = "[^a-zA-Z0-9_.]";

    private CategoryDTO(Builder builder) {
        this.typeId = builder.typeId;
        this.type = builder.type;
        if (builder.id != null) {
            if (builder.id.matches(ID_REGEX)) {
                this.id = builder.id;
            } else {
                LOGGER.warn(String.format("Category ID (%s) contains invalid characters, will remove them.", builder.id));
                this.id = builder.id.replaceAll(INVALID_ID_CHARS_REGEX, "");
            }
        } else {
            this.id = null;
        }
        this.name = builder.name == null ? builder.id : builder.name;
        this.applications = Collections.unmodifiableList(builder.applications);
        this.icon = builder.icon;
    }

    public URI getIcon() {
        return this.icon;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CategoryDTO that = (CategoryDTO)o;
        return new EqualsBuilder().append((Object)this.typeId, (Object)that.typeId).append((Object)this.type, (Object)that.type).append((Object)this.id, (Object)that.id).append((Object)this.name, (Object)that.name).append(this.applications, that.applications).append((Object)this.icon, (Object)that.icon).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.typeId).append((Object)this.type).append((Object)this.id).append((Object)this.name).append(this.applications).append((Object)this.icon).toHashCode();
    }

    public String getTypeId() {
        return this.typeId;
    }

    public CategoryType getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    @Translate
    public String getName() {
        return this.name;
    }

    @Translate
    public List<ApplicationDTO> getApplications() {
        return this.applications;
    }

    public static Comparator<CategoryDTO> nameComparator() {
        return (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName());
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.name).append((Object)this.type).toString();
    }

    @JsonPOJOBuilder(buildMethodName="build", withPrefix="with")
    @TranslatableBuilder
    public static class Builder {
        private String typeId;
        private CategoryType type;
        private String id;
        private String name;
        private List<ApplicationDTO> applications = new ArrayList<ApplicationDTO>();
        private URI icon;

        public Builder() {
        }

        public Builder(CategoryDTO categoryDTO) {
            this.withTypeId(categoryDTO.getTypeId()).withId(categoryDTO.getId()).withName(categoryDTO.getName()).withApplications(categoryDTO.getApplications()).withIcon(categoryDTO.getIcon()).withType(categoryDTO.getType());
        }

        public Builder withTypeId(String typeId) {
            this.typeId = typeId;
            return this;
        }

        public Builder withType(CategoryType type) {
            this.type = type;
            return this;
        }

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withApplications(List<ApplicationDTO> applications) {
            this.applications = applications;
            return this;
        }

        public Builder withIcon(URI iconPath) {
            this.icon = iconPath;
            return this;
        }

        public CategoryDTO build() {
            return new CategoryDTO(this);
        }

        public String getTypeId() {
            return this.typeId;
        }

        public String getId() {
            return this.id;
        }
    }

    public static enum CategoryType {
        INSTALLERS,
        FUNCTIONS;

    }
}

