/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.repository.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.phoenicis.configuration.localisation.Translatable;
import org.phoenicis.configuration.localisation.TranslatableBuilder;
import org.phoenicis.configuration.localisation.Translate;
import org.phoenicis.repository.dto.ResourceDTO;
import org.phoenicis.repository.dto.ScriptDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@Translatable
public class ApplicationDTO {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationDTO.class);
    private final String typeId;
    private final String categoryId;
    private final String id;
    private final String name;
    private final String description;
    private final URI icon;
    private final List<URI> miniatures;
    private final List<ScriptDTO> scripts;
    private final List<ResourceDTO> resources;
    private static final String ID_REGEX = "^[a-zA-Z0-9_.]+$";
    private static final String INVALID_ID_CHARS_REGEX = "[^a-zA-Z0-9_.]";

    private ApplicationDTO(Builder builder) {
        this.typeId = builder.typeId;
        this.categoryId = builder.categoryId;
        if (builder.id != null) {
            if (builder.id.matches(ID_REGEX)) {
                this.id = builder.id;
            } else {
                LOGGER.warn(String.format("Application ID (%s) contains invalid characters, will remove them.", builder.id));
                this.id = builder.id.replaceAll(INVALID_ID_CHARS_REGEX, "");
            }
        } else {
            this.id = null;
        }
        this.name = builder.name == null ? builder.id : builder.name;
        this.description = builder.description;
        this.icon = builder.icon;
        this.miniatures = builder.miniatures;
        this.scripts = builder.scripts;
        this.resources = builder.resources;
    }

    public static Comparator<ApplicationDTO> nameComparator() {
        return (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName());
    }

    public String getTypeId() {
        return this.typeId;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public List<ResourceDTO> getResources() {
        return this.resources;
    }

    public URI getIcon() {
        return this.icon;
    }

    public List<URI> getMiniatures() {
        return this.miniatures;
    }

    public String getId() {
        return this.id;
    }

    @Translate
    public String getName() {
        return this.name;
    }

    @Translate
    public String getDescription() {
        return this.description;
    }

    @Translate
    public List<ScriptDTO> getScripts() {
        return this.scripts;
    }

    @JsonIgnore
    public Optional<URI> getMainMiniature() {
        return this.miniatures.stream().filter(uri -> uri.getPath().endsWith("main.png")).findFirst();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationDTO that = (ApplicationDTO)o;
        return new EqualsBuilder().append((Object)this.typeId, (Object)that.typeId).append((Object)this.categoryId, (Object)that.categoryId).append((Object)this.id, (Object)that.id).append((Object)this.name, (Object)that.name).append((Object)this.description, (Object)that.description).append((Object)this.icon, (Object)that.icon).append(this.miniatures, that.miniatures).append(this.scripts, that.scripts).append(this.resources, that.resources).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.typeId).append((Object)this.categoryId).append((Object)this.id).append((Object)this.name).append((Object)this.description).append((Object)this.icon).append(this.miniatures).append(this.scripts).append(this.resources).toHashCode();
    }

    @JsonPOJOBuilder(buildMethodName="build", withPrefix="with")
    @TranslatableBuilder
    public static class Builder {
        private String typeId;
        private String categoryId;
        private String id;
        private String name;
        private String description;
        private URI icon;
        private List<URI> miniatures = new ArrayList<URI>();
        private List<ScriptDTO> scripts = new ArrayList<ScriptDTO>();
        private List<ResourceDTO> resources = new ArrayList<ResourceDTO>();

        public Builder() {
        }

        public Builder(ApplicationDTO applicationDTO) {
            this.typeId = applicationDTO.typeId;
            this.categoryId = applicationDTO.categoryId;
            this.id = applicationDTO.id;
            this.name = applicationDTO.name;
            this.description = applicationDTO.description;
            this.icon = applicationDTO.icon;
            this.miniatures = applicationDTO.miniatures;
            this.scripts = applicationDTO.scripts;
            this.resources = applicationDTO.resources;
        }

        public Builder withTypeId(String typeId) {
            this.typeId = typeId;
            return this;
        }

        public Builder withCategoryId(String categoryId) {
            this.categoryId = categoryId;
            return this;
        }

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withResources(List<ResourceDTO> resources) {
            this.resources = Collections.unmodifiableList(resources);
            return this;
        }

        public Builder withIcon(URI icon) {
            this.icon = icon;
            return this;
        }

        public Builder withMiniatures(List<URI> miniatures) {
            this.miniatures = miniatures;
            return this;
        }

        public Builder withScripts(List<ScriptDTO> scriptDTO) {
            this.scripts = scriptDTO;
            return this;
        }

        public ApplicationDTO build() {
            return new ApplicationDTO(this);
        }

        public String getTypeId() {
            return this.typeId;
        }

        public String getCategoryId() {
            return this.categoryId;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }
}

