/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.repository;

import java.io.File;
import java.util.concurrent.ExecutorService;
import org.phoenicis.configuration.PhoenicisGlobalConfiguration;
import org.phoenicis.multithreading.MultithreadingConfiguration;
import org.phoenicis.repository.DefaultRepositoryManager;
import org.phoenicis.repository.DynamicRepositoryLocationLoader;
import org.phoenicis.repository.FilesystemJsonRepositoryLocationLoader;
import org.phoenicis.repository.RepositoryLocationLoader;
import org.phoenicis.repository.RepositoryManager;
import org.phoenicis.repository.location.RepositoryLocation;
import org.phoenicis.repository.types.BackgroundRepository;
import org.phoenicis.repository.types.ClasspathRepository;
import org.phoenicis.repository.types.LocalRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

@Configuration
public class RepositoryConfiguration {
    @Value(value="${application.user.cache}")
    private String cacheDirectoryPath;
    @Value(value="${application.repository.list}")
    private String repositoryListPath;
    @Value(value="${application.repository.default.git.url}")
    private String defaultGitUrl;
    @Value(value="${application.repository.default.git.branch}")
    private String defaultGitBranch;
    @Value(value="${application.repository.default.classpath}")
    private String defaultClasspath;
    @Autowired
    private MultithreadingConfiguration multithreadingConfiguration;
    @Autowired
    private PhoenicisGlobalConfiguration phoenicisGlobalConfiguration;
    @Autowired
    private ApplicationContext applicationContext;
    @Value(value="${application.repository.location.loader.name:filesystemLocationLoader}")
    private String repositoryLocationLoaderName;

    @Bean
    public RepositoryManager repositoryManager() {
        DefaultRepositoryManager repositoryManager = new DefaultRepositoryManager((ExecutorService)this.multithreadingConfiguration.appsExecutorService(), this.cacheDirectoryPath, this.localRepositoryFactory(), this.classPathRepositoryFactory(), this.backgroundRepositoryFactory());
        repositoryManager.addRepositories(this.repositoryLocationLoader().loadRepositoryLocations().toArray(new RepositoryLocation[0]));
        return repositoryManager;
    }

    @Bean
    public RepositoryLocationLoader repositoryLocationLoader() {
        return new DynamicRepositoryLocationLoader(this.applicationContext, this.repositoryLocationLoaderName);
    }

    @Bean
    public RepositoryLocationLoader filesystemLocationLoader() {
        return new FilesystemJsonRepositoryLocationLoader(this.repositoryListPath, this.defaultGitUrl, this.defaultGitBranch, this.defaultClasspath, this.phoenicisGlobalConfiguration.objectMapper());
    }

    public void restoreDefault() {
        new File(this.repositoryListPath).deleteOnExit();
    }

    @Bean
    ClasspathRepository.Factory classPathRepositoryFactory() {
        return new ClasspathRepository.Factory(this.phoenicisGlobalConfiguration.objectMapper(), (ResourcePatternResolver)new PathMatchingResourcePatternResolver());
    }

    @Bean
    LocalRepository.Factory localRepositoryFactory() {
        return new LocalRepository.Factory(this.phoenicisGlobalConfiguration.objectMapper());
    }

    @Bean
    BackgroundRepository.Factory backgroundRepositoryFactory() {
        return new BackgroundRepository.Factory();
    }
}

