/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.repository;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.phoenicis.repository.RepositoryLocationLoader;
import org.phoenicis.repository.location.ClasspathRepositoryLocation;
import org.phoenicis.repository.location.GitRepositoryLocation;
import org.phoenicis.repository.location.RepositoryLocation;
import org.phoenicis.repository.types.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesystemJsonRepositoryLocationLoader
implements RepositoryLocationLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilesystemJsonRepositoryLocationLoader.class);
    private final String repositoryListPath;
    private final String defaultGitUrl;
    private final String defaultGitBranch;
    private final String defaultClasspath;
    private final ObjectMapper objectMapper;

    public FilesystemJsonRepositoryLocationLoader(String repositoryListPath, String defaultGitUrl, String defaultGitBranch, String defaultClasspath, ObjectMapper objectMapper) {
        this.repositoryListPath = repositoryListPath;
        this.defaultGitUrl = defaultGitUrl;
        this.defaultGitBranch = defaultGitBranch;
        this.defaultClasspath = defaultClasspath;
        this.objectMapper = objectMapper;
    }

    @Override
    public List<RepositoryLocation<? extends Repository>> getDefaultRepositoryLocations() {
        try {
            return ImmutableList.builder().add((Object)new GitRepositoryLocation.Builder().withGitRepositoryUri(new URL(this.defaultGitUrl).toURI()).withBranch(this.defaultGitBranch).build()).add((Object)new ClasspathRepositoryLocation(this.defaultClasspath)).build();
        }
        catch (MalformedURLException | URISyntaxException e) {
            LOGGER.error("Couldn't create default repository location list", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public List<RepositoryLocation<? extends Repository>> loadRepositoryLocations() {
        List<RepositoryLocation<Repository>> result = new ArrayList<RepositoryLocation<? extends Repository>>();
        File repositoryListFile = new File(this.repositoryListPath);
        if (repositoryListFile.exists()) {
            try {
                result = (List)this.objectMapper.readValue(new File(this.repositoryListPath), TypeFactory.defaultInstance().constructParametricType(List.class, new Class[]{RepositoryLocation.class}));
            }
            catch (IOException e) {
                LOGGER.error("Couldn't load repository location list", (Throwable)e);
            }
        } else {
            result.addAll(this.getDefaultRepositoryLocations());
        }
        return result;
    }

    @Override
    public void saveRepositories(List<RepositoryLocation<? extends Repository>> repositoryLocations) {
        try {
            this.objectMapper.writeValue(new File(this.repositoryListPath), repositoryLocations);
        }
        catch (IOException e) {
            LOGGER.error("Couldn't save repository location list", (Throwable)e);
        }
    }
}

