/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.repository;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.configuration.security.Safe;
import org.phoenicis.repository.RepositoryManager;
import org.phoenicis.repository.dto.ApplicationDTO;
import org.phoenicis.repository.dto.CategoryDTO;
import org.phoenicis.repository.dto.RepositoryDTO;
import org.phoenicis.repository.dto.ScriptDTO;
import org.phoenicis.repository.dto.TypeDTO;
import org.phoenicis.repository.location.RepositoryLocation;
import org.phoenicis.repository.types.BackgroundRepository;
import org.phoenicis.repository.types.CachedRepository;
import org.phoenicis.repository.types.ClasspathRepository;
import org.phoenicis.repository.types.LocalRepository;
import org.phoenicis.repository.types.MultipleRepository;
import org.phoenicis.repository.types.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Safe
public class DefaultRepositoryManager
implements RepositoryManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRepositoryManager.class);
    private final LocalRepository.Factory localRepositoryFactory;
    private final ClasspathRepository.Factory classPathRepositoryFactory;
    private final String cacheDirectoryPath;
    private Map<RepositoryLocation<? extends Repository>, Repository> repositoryMap;
    private MultipleRepository multipleRepository;
    private CachedRepository cachedRepository;
    private BackgroundRepository backgroundRepository;
    private List<CallbackPair> callbacks;
    private boolean isRepositoryLoaded = false;

    public DefaultRepositoryManager(ExecutorService executorService, String cacheDirectoryPath, LocalRepository.Factory localRepositoryFactory, ClasspathRepository.Factory classPathRepositoryFactory, BackgroundRepository.Factory backgroundRepositoryFactory) {
        this.localRepositoryFactory = localRepositoryFactory;
        this.classPathRepositoryFactory = classPathRepositoryFactory;
        this.cacheDirectoryPath = cacheDirectoryPath;
        this.repositoryMap = new HashMap<RepositoryLocation<? extends Repository>, Repository>();
        this.callbacks = new CopyOnWriteArrayList<CallbackPair>();
        this.multipleRepository = new MultipleRepository(new Repository[0]);
        this.cachedRepository = new CachedRepository(this.multipleRepository);
        this.backgroundRepository = backgroundRepositoryFactory.createInstance(this.cachedRepository, executorService);
    }

    @Override
    public synchronized void addCallbacks(Consumer<RepositoryDTO> onRepositoryChange, Consumer<Exception> onError) {
        this.callbacks.add(new CallbackPair(onRepositoryChange, onError));
    }

    @Override
    public TypeDTO getType(List<String> path) {
        return this.cachedRepository.getType(path);
    }

    @Override
    public CategoryDTO getCategory(List<String> path) {
        return this.cachedRepository.getCategory(path);
    }

    @Override
    public ApplicationDTO getApplication(List<String> path) {
        return this.cachedRepository.getApplication(path);
    }

    @Override
    public ScriptDTO getScript(List<String> path) {
        return this.cachedRepository.getScript(path);
    }

    @Override
    public ScriptDTO getScript(String id) {
        return this.cachedRepository.getScript(id);
    }

    @Override
    public void moveRepository(RepositoryLocation<? extends Repository> repositoryUrl, int toIndex) {
        LOGGER.info(String.format("Move repository: %s to %d", repositoryUrl, toIndex));
        this.multipleRepository.moveRepository(this.repositoryMap.get(repositoryUrl), toIndex);
        this.triggerRepositoryChange();
    }

    @Override
    public synchronized void updateRepositories(List<RepositoryLocation<? extends Repository>> repositoryLocations) {
        LOGGER.info(String.format("Updating repositories list to %s", repositoryLocations.toString()));
        HashMap<RepositoryLocation<? extends Repository>, Repository> copy = new HashMap<RepositoryLocation<? extends Repository>, Repository>(this.repositoryMap);
        copy.forEach((repositoryLocation, repository) -> {
            this.multipleRepository.removeRepository((Repository)repository);
            if (!repositoryLocations.contains(repositoryLocation)) {
                this.repositoryMap.remove(repositoryLocation);
                repository.onDelete();
            }
        });
        repositoryLocations.forEach(repositoryLocation -> {
            if (!this.repositoryMap.containsKey(repositoryLocation)) {
                Object repository = repositoryLocation.createRepository(this.cacheDirectoryPath, this.localRepositoryFactory, this.classPathRepositoryFactory);
                this.repositoryMap.put((RepositoryLocation<? extends Repository>)repositoryLocation, (Repository)repository);
            }
            this.multipleRepository.addRepository(this.repositoryMap.get(repositoryLocation));
        });
        this.triggerRepositoryChange();
    }

    @Override
    public synchronized void addRepositories(int index, RepositoryLocation<? extends Repository> ... repositoryUrls) {
        LOGGER.info(String.format("Adding repositories: %s at index %d", Arrays.toString(repositoryUrls), index));
        for (int repositoryUrlIndex = 0; repositoryUrlIndex < repositoryUrls.length; ++repositoryUrlIndex) {
            Repository repository = repositoryUrls[repositoryUrlIndex].createRepository(this.cacheDirectoryPath, this.localRepositoryFactory, this.classPathRepositoryFactory);
            this.repositoryMap.put(repositoryUrls[repositoryUrlIndex], repository);
            this.multipleRepository.addRepository(index + repositoryUrlIndex, repository);
        }
        this.triggerRepositoryChange();
    }

    @Override
    public synchronized void addRepositories(RepositoryLocation<? extends Repository> ... repositoryUrls) {
        this.addRepositories(this.multipleRepository.size(), repositoryUrls);
    }

    @Override
    public synchronized void removeRepositories(RepositoryLocation<? extends Repository> ... repositoryUrls) {
        LOGGER.info(String.format("Removing repositories: %s", Arrays.toString(repositoryUrls)));
        for (RepositoryLocation<? extends Repository> repositoryLocation : repositoryUrls) {
            Repository deletedRepository = this.repositoryMap.remove(repositoryLocation);
            this.multipleRepository.removeRepository(deletedRepository);
            deletedRepository.onDelete();
        }
        this.triggerRepositoryChange();
    }

    @Override
    public synchronized void triggerRepositoryChange() {
        this.cachedRepository.clearCache();
        this.triggerCallbacks();
    }

    @Override
    public synchronized void triggerCallbacks() {
        if (!this.callbacks.isEmpty()) {
            this.backgroundRepository.fetchInstallableApplications(repositoryDTO -> this.callbacks.forEach(callbackPair -> callbackPair.getOnRepositoryChange().accept((RepositoryDTO)Localisation.tr((Object)repositoryDTO))), exception -> this.callbacks.forEach(callbackPair -> callbackPair.getOnError().accept((Exception)exception)));
            this.isRepositoryLoaded = true;
        }
    }

    @Override
    public synchronized boolean isRepositoryLoaded() {
        return this.isRepositoryLoaded;
    }

    private class CallbackPair {
        private Consumer<RepositoryDTO> onRepositoryChange;
        private Consumer<Exception> onError;

        public CallbackPair(Consumer<RepositoryDTO> onRepositoryChange, Consumer<Exception> onError) {
            this.onRepositoryChange = onRepositoryChange;
            this.onError = onError;
        }

        public Consumer<RepositoryDTO> getOnRepositoryChange() {
            return this.onRepositoryChange;
        }

        public Consumer<Exception> getOnError() {
            return this.onError;
        }
    }
}

