/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.polyglot.PolyglotIterable;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.ToHostNode;
import com.oracle.truffle.polyglot.ToHostNodeGen;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=PolyglotIterable.class)
final class PolyglotIterableFactory {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    PolyglotIterableFactory() {
    }

    @GeneratedBy(value=PolyglotIterable.Cache.class)
    static final class CacheFactory {
        CacheFactory() {
        }

        @GeneratedBy(value=PolyglotIterable.Cache.GetIteratorNode.class)
        static final class GetIteratorNodeGen
        extends PolyglotIterable.Cache.GetIteratorNode {
            @CompilerDirectives.CompilationFinal
            private volatile int state_0_;
            @CompilerDirectives.CompilationFinal
            private volatile int exclude_;
            @Node.Child
            private Cached0Data cached0_cache;
            @Node.Child
            private ToHostNode cached1_toHost_;
            @CompilerDirectives.CompilationFinal
            private BranchProfile cached1_error_;

            private GetIteratorNodeGen(PolyglotIterable.Cache cache) {
                super(cache);
            }

            @Override
            @ExplodeLoop
            protected Object executeImpl(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0) {
                    if ((state_0 & 1) != 0) {
                        Cached0Data s1_ = this.cached0_cache;
                        while (s1_ != null) {
                            if (s1_.iterables_.accepts(arg1Value)) {
                                return this.doCached(arg0Value, arg1Value, arg2Value, s1_.iterables_, s1_.toHost_, s1_.error_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state_0 & 2) != 0) {
                        return this.cached1Boundary(state_0, arg0Value, arg1Value, arg2Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @CompilerDirectives.TruffleBoundary
            private Object cached1Boundary(int state_0, PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set(this);
                try {
                    InteropLibrary cached1_iterables__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value);
                    Object object = this.doCached(arg0Value, arg1Value, arg2Value, cached1_iterables__, this.cached1_toHost_, this.cached1_error_);
                    return object;
                }
                finally {
                    encapsulating_.set(prev_);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object executeAndSpecialize(PolyglotLanguageContext arg0Value, Object arg1Value, Object[] arg2Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                int exclude = this.exclude_;
                try {
                    Object object;
                    if (exclude == 0) {
                        int count1_ = 0;
                        Cached0Data s1_ = this.cached0_cache;
                        if ((state_0 & 1) != 0) {
                            while (s1_ != null && !s1_.iterables_.accepts(arg1Value)) {
                                s1_ = s1_.next_;
                                ++count1_;
                            }
                        }
                        if (s1_ == null && count1_ < 5) {
                            s1_ = super.insert(new Cached0Data(this.cached0_cache));
                            s1_.iterables_ = (InteropLibrary)s1_.insertAccessor(INTEROP_LIBRARY_.create(arg1Value));
                            s1_.toHost_ = s1_.insertAccessor(ToHostNodeGen.create());
                            s1_.error_ = BranchProfile.create();
                            this.cached0_cache = s1_;
                            this.state_0_ = state_0 |= 1;
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            Object object2 = this.doCached(arg0Value, arg1Value, arg2Value, s1_.iterables_, s1_.toHost_, s1_.error_);
                            return object2;
                        }
                    }
                    InteropLibrary cached1_iterables__ = null;
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set(this);
                    try {
                        cached1_iterables__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value);
                        this.cached1_toHost_ = super.insert(ToHostNodeGen.create());
                        this.cached1_error_ = BranchProfile.create();
                        this.exclude_ = exclude |= 1;
                        this.cached0_cache = null;
                        state_0 &= 0xFFFFFFFE;
                        this.state_0_ = state_0 |= 2;
                        lock.unlock();
                        hasLock = false;
                        object = this.doCached(arg0Value, arg1Value, arg2Value, cached1_iterables__, this.cached1_toHost_, this.cached1_error_);
                        encapsulating_.set(prev_);
                    }
                    catch (Throwable throwable) {
                        encapsulating_.set(prev_);
                        throw throwable;
                    }
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                Cached0Data s1_;
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & state_0 - 1) == 0 && ((s1_ = this.cached0_cache) == null || s1_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            public static PolyglotIterable.Cache.GetIteratorNode create(PolyglotIterable.Cache cache) {
                return new GetIteratorNodeGen(cache);
            }

            @GeneratedBy(value=PolyglotIterable.Cache.GetIteratorNode.class)
            private static final class Cached0Data
            extends Node {
                @Node.Child
                Cached0Data next_;
                @Node.Child
                InteropLibrary iterables_;
                @Node.Child
                ToHostNode toHost_;
                @CompilerDirectives.CompilationFinal
                BranchProfile error_;

                Cached0Data(Cached0Data next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return super.insert(node);
                }
            }
        }
    }
}

