/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.tools.win32;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.phoenicis.configuration.security.Safe;
import org.phoenicis.win32.pe.PEFile;
import org.phoenicis.win32.pe.PEReader;

@Safe
public class ExeAnalyser {
    private final PEReader peReader;

    public ExeAnalyser(PEReader peReader) {
        this.peReader = peReader;
    }

    public boolean is64Bits(File file) throws IOException {
        return this.isArchitecture(file, PEFile.Architecture.AMD64);
    }

    public boolean is32Bits(File file) throws IOException {
        return this.isArchitecture(file, PEFile.Architecture.I386);
    }

    private boolean isArchitecture(File file, PEFile.Architecture architecture) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            PEFile peFile = this.peReader.parseExecutable((InputStream)inputStream);
            boolean bl = peFile.getArchitecture() == architecture;
            return bl;
        }
    }
}

