/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.tools.version;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.phoenicis.configuration.security.Safe;

@Safe
public class Version {
    private final int bigNumber;
    private final int intermediateNumber;
    private final int lowNumber;
    private final String customName;

    public Version(String completeVersionAsString) {
        String[] splitCompleteVersion = completeVersionAsString.split("-");
        String versionAsString = splitCompleteVersion[0];
        this.customName = splitCompleteVersion.length > 1 ? splitCompleteVersion[1].trim() : "";
        String[] splitVersion = versionAsString.split("\\.");
        this.bigNumber = this.readInteger(splitVersion[0]);
        this.intermediateNumber = splitVersion.length <= 1 ? 0 : this.readInteger(splitVersion[1]);
        this.lowNumber = splitVersion.length <= 2 ? 0 : this.readInteger(splitVersion[2]);
    }

    private int readInteger(String number) {
        try {
            return Integer.valueOf(number);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public int getBigNumber() {
        return this.bigNumber;
    }

    public int getIntermediateNumber() {
        return this.intermediateNumber;
    }

    public int getLowNumber() {
        return this.lowNumber;
    }

    public String getCustomName() {
        return this.customName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return new EqualsBuilder().append(this.bigNumber, version.bigNumber).append(this.intermediateNumber, version.intermediateNumber).append(this.lowNumber, version.lowNumber).append((Object)this.customName, (Object)version.customName).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.bigNumber).append(this.intermediateNumber).append(this.lowNumber).toHashCode();
    }

    public String toString() {
        if (StringUtils.isBlank((String)this.customName)) {
            if (this.lowNumber == 0) {
                return String.format("%s.%s", this.bigNumber, this.intermediateNumber);
            }
            return String.format("%s.%s.%s", this.bigNumber, this.intermediateNumber, this.lowNumber);
        }
        if (this.lowNumber == 0) {
            return String.format("%s.%s-%s", this.bigNumber, this.intermediateNumber, this.customName);
        }
        return String.format("%s.%s.%s-%s", this.bigNumber, this.intermediateNumber, this.lowNumber, this.customName);
    }
}

