/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.tools.system.terminal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.phoenicis.configuration.security.Safe;
import org.phoenicis.tools.system.terminal.TerminalOpener;

@Safe
class MacOSTerminalOpener
implements TerminalOpener {
    MacOSTerminalOpener() {
    }

    @Override
    public void openTerminal(String workingDirectory, Map<String, String> environmentVariables) {
        block7: {
            try {
                File temporaryScript = File.createTempFile("terminal", "sh");
                if (!temporaryScript.setExecutable(true)) break block7;
                temporaryScript.deleteOnExit();
                try (FileOutputStream fileOutputStream = new FileOutputStream(temporaryScript);){
                    IOUtils.write((String)this.createScript(workingDirectory, environmentVariables), (OutputStream)fileOutputStream, (String)"UTF-8");
                    fileOutputStream.flush();
                }
                ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command("/usr/bin/open", "-b", "com.apple.terminal", temporaryScript.getAbsolutePath());
                processBuilder.start();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private String createScript(String workingDirectory, Map<String, String> environmentVariables) {
        StringBuilder scriptBuilder = new StringBuilder();
        scriptBuilder.append("cd \"").append(workingDirectory).append("\" \n").append("[ -e \"$HOME/.profile\" ] && rcFile=\"~/.profile\" || rcFile=\"/etc/profile\"\n");
        for (Map.Entry<String, String> entry : environmentVariables.entrySet()) {
            scriptBuilder.append(String.format("export %s=\"%s\"%n", entry.getKey(), entry.getValue()));
        }
        return scriptBuilder.append("exec bash -c \"clear;printf '\\e[3J';bash --rcfile $rcFile\"").toString();
    }
}

