/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.tools.system.terminal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.phoenicis.configuration.security.Safe;
import org.phoenicis.tools.system.terminal.TerminalOpener;

@Safe
class LinuxTerminalOpener
implements TerminalOpener {
    private Optional<String> terminalCommand;

    public LinuxTerminalOpener() {
        this(Optional.empty());
    }

    public LinuxTerminalOpener(Optional<String> terminalCommand) {
        this.terminalCommand = terminalCommand;
    }

    @Override
    public void openTerminal(String workingDirectory, Map<String, String> environmentVariables) {
        block7: {
            try {
                File temporaryScript = File.createTempFile("terminal", "sh");
                if (!temporaryScript.setExecutable(true)) break block7;
                temporaryScript.deleteOnExit();
                try (FileOutputStream fileOutputStream = new FileOutputStream(temporaryScript);){
                    IOUtils.write((String)this.createScript(workingDirectory, environmentVariables), (OutputStream)fileOutputStream, (String)"UTF-8");
                    fileOutputStream.flush();
                }
                ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(this.terminalCommand.orElse("xterm"), "-e", "bash -c '" + temporaryScript.getAbsolutePath() + "'");
                processBuilder.start();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private String createScript(String workingDirectory, Map<String, String> environmentVariables) {
        StringBuilder scriptBuilder = new StringBuilder();
        scriptBuilder.append("cd \"").append(workingDirectory).append("\"\n");
        for (Map.Entry<String, String> entry : environmentVariables.entrySet()) {
            scriptBuilder.append(String.format("export %s=\"%s\"\n", entry.getKey(), entry.getValue()));
        }
        return scriptBuilder.append("exec $SHELL").toString();
    }
}

