/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.tools.system.terminal;

import java.util.Map;
import java.util.Optional;
import org.phoenicis.configuration.security.Safe;
import org.phoenicis.tools.system.OperatingSystemFetcher;
import org.phoenicis.tools.system.terminal.LinuxTerminalOpener;
import org.phoenicis.tools.system.terminal.MacOSTerminalOpener;
import org.phoenicis.tools.system.terminal.TerminalOpener;
import org.phoenicis.tools.system.terminal.TerminalOpenerFactory;

@Safe
public class AutomaticTerminalOpener
implements TerminalOpener {
    private final TerminalOpener terminalOpener;

    public AutomaticTerminalOpener(TerminalOpenerFactory terminalOpenerFactory, OperatingSystemFetcher operatingSystemFetcher, Optional<String> linuxTerminalCommand) {
        switch (operatingSystemFetcher.fetchCurrentOperationSystem()) {
            case LINUX: {
                this.terminalOpener = terminalOpenerFactory.createInstance(LinuxTerminalOpener.class, linuxTerminalCommand);
                break;
            }
            case MACOSX: {
                this.terminalOpener = terminalOpenerFactory.createInstance(MacOSTerminalOpener.class);
                break;
            }
            default: {
                this.terminalOpener = (workingDirectory, environmentVariables) -> {
                    throw new UnsupportedOperationException();
                };
            }
        }
    }

    public AutomaticTerminalOpener(TerminalOpenerFactory terminalOpenerFactory, OperatingSystemFetcher operatingSystemFetcher) {
        this(terminalOpenerFactory, operatingSystemFetcher, Optional.empty());
    }

    @Override
    public void openTerminal(String workingDirectory, Map<String, String> environmentVariables) {
        this.terminalOpener.openTerminal(workingDirectory, environmentVariables);
    }
}

